package gov.va.med.mhv.sm.api.common;


import gov.va.med.mhv.sm.api.transfer.FolderTO;
import gov.va.med.mhv.sm.api.transfer.FoldersTO;
import gov.va.med.mhv.sm.api.transfer.MessagesTO;
import gov.va.med.mhv.sm.api.transfer.MessageSearchFormTO;
import gov.va.med.mhv.sm.enumeration.MessagesOrderByEnum;
import gov.va.med.mhv.sm.enumeration.SortOrderEnum;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Consumes({"application/xml","application/json"})
@Produces({"application/xml","application/json"})
public interface FolderAPIService {
    
	@GET
	@Path("")
	public FoldersTO getFolders();

	@GET
	@Path("{folderId}")
	public FolderTO getFolder( @javax.ws.rs.PathParam("folderId") Long folderId );

	@GET
	@Path("{folderId}/message/page/{pageNumber}/pageSize/{pageSize}")
	public MessagesTO getMessagesForFolder(@javax.ws.rs.PathParam("folderId") Long folderId, @javax.ws.rs.PathParam("pageNumber") Long pageNumber, @javax.ws.rs.PathParam("pageSize") Long pageSize);

	@POST
	@Path("/")
	public FolderTO createFolder( FolderTO folder );
	
	@DELETE
	@Path("{folderId}")
	public Response deleteFolder(@javax.ws.rs.PathParam("folderId") Long folderId);

	@GET
	@Path("{folderId}/message/page/{pageNumber}/pageSize/{pageSize}/sort/{sortField}/order/{sortOrder}")
	public MessagesTO getMessagesForFolder(@javax.ws.rs.PathParam("folderId") Long folderId, @javax.ws.rs.PathParam("pageNumber") Long pageNumber, @javax.ws.rs.PathParam("pageSize") Long pageSize, @javax.ws.rs.PathParam("sortField") MessagesOrderByEnum sortField, @javax.ws.rs.PathParam("sortOrder") SortOrderEnum sortOrder);

	@POST
	@Path("{folderId}/searchMessage/page/{pageNumber}/pageSize/{pageSize}")
	public MessagesTO searchForMessagesInFolder(@javax.ws.rs.PathParam("folderId") Long folderId, @javax.ws.rs.PathParam("pageNumber") Long pageNumber, @javax.ws.rs.PathParam("pageSize") Long pageSize, MessageSearchFormTO searchForm);
	
}
