package gov.va.med.mhv.sm.api.clinician.impl;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.sm.api.clinician.DistributionGroupAPIService;
import gov.va.med.mhv.sm.api.common.SessionAPIService;
import gov.va.med.mhv.sm.api.enumeration.ErrorEnum;
import gov.va.med.mhv.sm.api.transfer.DistributionGroupTO;
import gov.va.med.mhv.sm.api.transfer.DistributionGroupsTO;
import gov.va.med.mhv.sm.api.transfer.Session;
import gov.va.med.mhv.sm.api.util.SMApiUtility;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.DistributionGroup;
import gov.va.med.mhv.sm.service.DistributionGroupService;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.annotation.Resource;

import org.apache.cxf.jaxrs.ext.MessageContext;

public class DistributionGroupAPIServiceImpl implements
		DistributionGroupAPIService {

	private SessionAPIService sessionApiService;
	private DistributionGroupService distributionGroupService;
	
	@Resource
	MessageContext mc;
	
	@Override
	public DistributionGroupsTO getDistributionGroups() {
		Session session = sessionApiService.checkSession(mc);
		Clinician c = (Clinician)session.getClinician();
		CollectionServiceResponse<DistributionGroup> response = distributionGroupService.getDistributionGroupsAndOwnersForClinician(c);
		SMApiUtility.throwExceptionOnErrors(ErrorEnum.DISTRIBUTION_GROUP_SERVICE_ERROR_905, response);
		Collection<DistributionGroup> list = response.getCollection();
		
		List<DistributionGroupTO> distributionGroupArray = new ArrayList<DistributionGroupTO>();
		for(DistributionGroup dg : list) {	
			distributionGroupArray.add(new DistributionGroupTO(dg.getName(), dg.getId(), dg.getOwner().getLastName()+","+dg.getOwner().getFirstName(), dg.isPublicGroup(), dg.getVisnId()));
		}
		
		return new DistributionGroupsTO(distributionGroupArray); 
	}

	public SessionAPIService getSessionApiService() {
		return sessionApiService;
	}
	public void setSessionApiService(SessionAPIService sessionService) {
		this.sessionApiService = sessionService;
	}
	public DistributionGroupService getDistributionGroupService() {
		return distributionGroupService;
	}
	public void setDistributionGroupService(DistributionGroupService distributionGroupService) {
		this.distributionGroupService = distributionGroupService;
	}
	
}
