package gov.va.med.mhv.sm.api.clinician;

import gov.va.med.mhv.sm.api.transfer.ClinicianMessageTO;
import gov.va.med.mhv.sm.api.transfer.ClinicianMessagesTO;
import gov.va.med.mhv.sm.api.transfer.ClinicianStatusTO;
import gov.va.med.mhv.sm.api.transfer.ClinicianStatusTypesTO;
import gov.va.med.mhv.sm.api.transfer.CommentTO;
import gov.va.med.mhv.sm.api.transfer.CommentsTO;
import gov.va.med.mhv.sm.api.transfer.MessageCategoryTypesTO;

import java.util.Date;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;

@Produces({"application/octet-stream","application/xml","application/json"})
@Consumes({"multipart/form-data","application/xml","application/json"})
public interface MessageAPIService {

	@POST
	@Path("/")
	public ClinicianMessageTO sendMessage(ClinicianMessageTO clinicMessage);
	
	@POST
	@Path("/attach")
	public ClinicianMessageTO sendMessageWithAttachment( @Multipart(value = "message") ClinicianMessageTO message, List<Attachment> attachments );
	
	@POST
	@Path("/{messageId}")
	public Response deleteMessage(@javax.ws.rs.PathParam("messageId") Long messageId);
	
	@POST
	@Path("/{messageId}/move/tofolder/{folderId}")
	public Response moveMessage(@javax.ws.rs.PathParam("messageId") Long messageId, @javax.ws.rs.PathParam("folderId") Long folderId);
	
	@GET
	@Path("/{messageId}/attachment/{attachmentId}")
	public Response getMessageAttachment(@javax.ws.rs.PathParam("messageId") Long messageId, @javax.ws.rs.PathParam("attachmentId") Long attachmentId); //MultipartBody
	
	@POST
	@Path("/{messageId}/reply")
	public ClinicianMessageTO replyMessage(@javax.ws.rs.PathParam("messageId") Long messageId, ClinicianMessageTO message);
	
	@POST
	@Path("/{messageId}/reply/attach")
	public ClinicianMessageTO replyMessageWithAttachment(@javax.ws.rs.PathParam("messageId") Long messageId, @Multipart(value = "message") ClinicianMessageTO message, List<Attachment> attachments );
	
	@GET
	@Path("/{messageId}/read")
	public ClinicianMessageTO readMessage(@javax.ws.rs.PathParam("messageId") Long messageId);
	
	@GET
	@Path("/{messageId}/history")
	public ClinicianMessagesTO getMessageHistory( @javax.ws.rs.PathParam("messageId") Long messageId );

	@POST
	@Path("/draft")
	public ClinicianMessageTO saveDraftMessage(ClinicianMessageTO message);
	
	@POST
	@Path("/{messageId}/replydraft")
	public ClinicianMessageTO saveReplyDraft(@javax.ws.rs.PathParam("messageId") Long currentMessageId, ClinicianMessageTO message);
		

	@GET
	@Path("/category")
	public MessageCategoryTypesTO getMessageCategoryTypes();
	
	//--- PROVIDER

	@GET
	@Path("/clinicianstatustypes")
	public ClinicianStatusTypesTO getClinicianStatusTypes();

	@GET
	@Path("{messageId}/comment")
	public CommentsTO getComments(@javax.ws.rs.PathParam("messageId") Long messageId);
	
	@POST
	@Path("{messageId}/comment")
	public CommentsTO addComment(@javax.ws.rs.PathParam("messageId") Long messageId, CommentTO comment);
	
	@POST
	@Path("{messageId}/status")
	public ClinicianMessageTO setStatus(@javax.ws.rs.PathParam("messageId") Long messageId, ClinicianStatusTO clinicianStatus);

	//-------------------

	@POST
	@Path("{messageId}/forward")
	public ClinicianMessageTO forwardMessage(@javax.ws.rs.PathParam("messageId") Long messageId, ClinicianMessageTO message);
	
	@POST
	@Path("{messageId}/reassign/{userId}")
	public ClinicianMessageTO reassign(@javax.ws.rs.PathParam("messageId") Long messageId, @javax.ws.rs.PathParam("userId") Long userId);

	@POST
	@Path("/{messageId}/saveToCPRS")
	public ClinicianMessageTO saveToCPRS(@javax.ws.rs.PathParam("messageId") Long messageId, Long messages[]);

	@POST
	@Path("/{messageId}/reminder")
	public ClinicianMessageTO setReminderForMessage(@javax.ws.rs.PathParam("messageId") Long messageId, String reminderDate);

	@DELETE
	@Path("/{messageId}/reminder")
	public ClinicianMessageTO removeReminderForMessage(@javax.ws.rs.PathParam("messageId") Long messageId);

	@GET
	@Path("/{messageId}/historyForCPRS")
	public ClinicianMessagesTO getMessageHistoryForCPRS( @javax.ws.rs.PathParam("messageId") Long messageId );

}
