package gov.va.med.mhv.sm.api.cache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class CacheHandler {
	private static final Log log = LogFactory.getLog(CacheHandler.class);
	
	public static ThreadLocal<CacheEntry> instance = new ThreadLocal<CacheEntry>() {
		 protected synchronized CacheEntry initialValue() {
			 if(log.isDebugEnabled())log.debug("[Thread " + Thread.currentThread().getId() + "] initialValue called " );
			 return null;
         }
    };
	
    public static CacheEntry getInstance() {
    	if(CacheHandler.instance.get()==null) {
    		if(log.isDebugEnabled())log.debug("[Thread " + Thread.currentThread().getId() + "] getInstance called " );
                synchronized(instance) {
            	CacheEntry entry = new CacheEntry();
            	CacheHandler.instance.set(entry);
            }
        }
        return (CacheEntry)CacheHandler.instance.get();
    }
    
    public static void resetInstance() {
    	if(log.isDebugEnabled())log.debug("[Thread " + Thread.currentThread().getId() + "] resetInstance called " );
    	getInstance().setSession(null);
    	getInstance().setError(null);
    	getInstance().setInboundMessage(null);
    }
    
}  
