package gov.va.med.fw.validation;

// Framework classes
import gov.va.med.fw.service.ServiceException;

/**
 * This is an interface to be implemented be validation services.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public interface ValidationService {
	/**
	 * Validates the input data.
	 * 
	 * @param input
	 *            the data to be validated.
	 * 
	 * @return the validation messages.
	 * @throws ValidationServiceException
	 *             thrown when there is an error while validating.
	 */
	public ValidationMessages validate(Validatable input) throws ServiceException;
}
