/*******************************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.fw.util.builder.decorator;

// Java Classes

// Library Classes

// Framework Classes
import gov.va.med.fw.util.builder.Validator;
import gov.va.med.fw.util.builder.ValidatorException;

// Common Classes

// Messaging Classes

/**
 * @author Martin Francisco
 */
public class ChainedValidator implements Validator {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -9179209889538500420L;

	private Validator[] validators;

	public static Validator decorate(Validator[] validators) {
		return new ChainedValidator(validators);
	}

	private ChainedValidator(Validator[] validators) {
		super();

		this.validators = validators;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.util.builder.Validator#validate(java.lang.Object)
	 */
	public void validate(Object input) throws ValidatorException {
		for (int index = 0; index < this.validators.length; index++) {
			this.validators[index].validate(input);
		}
	}
}