/********************************************************************
 Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.util.builder.decorator;

import gov.va.med.fw.util.builder.Builder;

/**
 * An abstract decorator class for builders.
 * 
 * @author Martin Francisco
 */
public abstract class AbstractBuilderDecorator implements Builder {
	private static final long serialVersionUID = -1370346746640850300L;
	/**
	 * The builder being decorated.
	 */
	private Builder builder;

	/**
	 * Constructs the decorator.
	 * 
	 * @param builder
	 *            The builder being decorated.
	 * @throws IllegalArgumentException
	 *             Thrown if the builder is null.
	 */
	protected AbstractBuilderDecorator(Builder builder) {
		super();

		if (builder == null) {
			throw new IllegalArgumentException("builder cannot be null");
		} else {
			this.builder = builder;
		}
	}

	/**
	 * Returns the builder being decorated.
	 * 
	 * @return The builder being decorated.
	 */
	protected final Builder getBuilder() {
		return this.builder;
	}
}