/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.util;

import java.util.Properties;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;

/**
 * CISS ciss_common July 29, 2008
 * 
 * @author Muddaiah Ranga
 */
public class VersionInfo extends AbstractComponent {

	private Properties versionProperties;

	public String getVersion() throws ServiceException {
		StringBuilder version = new StringBuilder();
		if (versionProperties != null) {
			version.append(versionProperties.getProperty("major.rel.num"));
			version.append(".");
			version.append(versionProperties.getProperty("minor.rel.num"));
			version.append(".");
			version.append(versionProperties.getProperty("patch.rel.num"));
			version.append(".");
			version.append(versionProperties.getProperty("sqa.num"));
			version.append(versionProperties.getProperty("build.num"));
		}
		return version.toString();
	}

	public Properties getVersionProperties() {
		return versionProperties;
	}

	public void setVersionProperties(Properties versionProperties) {
		this.versionProperties = versionProperties;
	}
}
