/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.util;

// Java classes
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Iterator;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/**
 * @author VHAISALEV
 * @version 1.0
 */
public class SegmentClassGenerator {

	protected SegmentClassGenerator() {
		super();
	}

	public static void generate(String descriptor) throws Exception {
		Document document = getDescriptorDocument(descriptor);
		Element root = document.getRootElement();

		String copyright = root.element("copyright").getStringValue();
		String header = root.element("header").getStringValue();
		String imports = root.element("imports").getStringValue();
		String className = root.element("class").getStringValue();
		String packageName = root.element("package").getStringValue();
		String constructors = root.element("constructors").getStringValue();
		String location = root.element("location").getStringValue();

		PrintWriter writer = new PrintWriter(new BufferedOutputStream(new FileOutputStream(location
				+ "/" + className + ".java")));
		writer.println(copyright);
		writer.println("package " + packageName + ";");
		writer.println("\n");
		writer.println(imports);
		writer.println("\n");
		writer.println(header);
		writer.println("public class " + className + " extends Segment {");
		writer.println(constructors);

		// Get a list of elements
		for (Iterator i = root.elementIterator("element"); i.hasNext();) {
			Element e = (Element) i.next();
			String name = e.element("name").getStringValue();
			String index = e.element("index").getStringValue();
			String comment = e.element("comment").getStringValue();
			Element eType = e.element("type");
			String type = (eType != null ? eType.getStringValue() : "String");

			// Generate set method
			writer.println("/**");
			writer.println(" * " + comment);
			writer.println(" * @param input A value of " + name);
			writer.println(" */");
			writer.println("public void set" + name + "( " + type + " input ) {");
			writer.println("\t setElement( input, " + index + " );");
			writer.println("}");

			// generate get method
			writer.println("/**");
			writer.println(" * " + comment);
			writer.println(" * @return String A value of " + name);
			writer.println(" */");
			writer.println("public " + type + " get" + name + "() {");
			writer.println("\t return getElement( " + index + " );");
			writer.println("}");
		}
		writer.println("}");
		writer.flush();
		writer.close();
	}

	protected static Document getDescriptorDocument(String name) throws Exception {

		SAXReader reader = new SAXReader();
		Document document = reader.read(SegmentClassGenerator.class.getClassLoader()
				.getResourceAsStream(name));
		return document;
	}

	public static void main(String[] args) throws Exception {

		if (args.length != 1) {
			System.out.println("Usage: name_segment_descriptor.xml ");
		}

		generate(args[0]);
	}
}
