/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.util;

import java.util.Collection;
import java.util.Map;

import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;

import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * Initial javadoc for class PerformanceMonitorInterceptor. TODO - Add content
 * here
 * 
 * Created Oct 31, 2006 2:28:38 PM
 * 
 * @author VHAISABOHMEG
 */
public class PerformanceMonitorInterceptor extends
		org.springframework.aop.interceptor.PerformanceMonitorInterceptor {
	public PerformanceMonitorInterceptor() {
	}

	/**
	 * Create a new PerformanceMonitorInterceptor with a dynamic or static
	 * logger, according to the given flag.
	 * 
	 * @param useDynamicLogger
	 *            whether to use a dynamic logger or a static logger
	 * @see #setUseDynamicLogger
	 */
	public PerformanceMonitorInterceptor(boolean useDynamicLogger) {
		super(useDynamicLogger);
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = -336252774383149791L;

	/*
	 * (non-Javadoc)
	 * 
	 * @seeorg.springframework.aop.interceptor.PerformanceMonitorInterceptor#
	 * invokeUnderTrace(org.aopalliance.intercept.MethodInvocation,
	 * org.apache.commons.logging.Log)
	 */
	protected Object invokeUnderTrace(MethodInvocation invocation, Log logger) throws Throwable {
		String name = createInvocationTraceName(invocation);
		StopWatchLogger stopWatch = new StopWatchLogger(name);
		stopWatch.start(name);
		String returnDataSummary = null;
		try {
			Object obj = invocation.proceed();

			if (obj != null) {
				if (obj instanceof Object[])
					returnDataSummary = "returned Object[] of length: " + ((Object[]) obj).length;
				else if (obj instanceof Collection)
					returnDataSummary = "returned Collection of size: " + ((Collection) obj).size();
				else if (obj instanceof Map)
					returnDataSummary = "returned  Map of size: " + ((Map) obj).size();
				else if (obj instanceof AbstractKeyedEntity)
					returnDataSummary = "returned  AbstractKeyedEntity with Id: "
							+ ((AbstractKeyedEntity) obj).getId();
			}
			return obj;
		} finally {
			stopWatch.stopAndLog(returnDataSummary, logger);
		}
	}
}
