// Package 
package gov.va.med.fw.util;

/**
 * This class provides generic helper methods for numbers.
 * 
 * @author Andrew Pach
 * @version 4.0
 */
public class NumberUtils extends org.apache.commons.lang.math.NumberUtils {
	/**
	 * Adds the additional value onto the original value and handles nulls. If
	 * the original value is null, the additional value will be returned. If the
	 * additional value is null, the original value will be returned.
	 * 
	 * @param originalValue
	 *            the original value.
	 * @param additionalValue
	 *            the value to add to the original value.
	 * 
	 * @return the sum of the two values.
	 */
	public static Integer addIntegerValues(Integer originalValue, Integer additionalValue) {
		if (originalValue == null) {
			return additionalValue;
		} else {
			if (additionalValue == null) {
				return originalValue;
			} else {
				return originalValue + additionalValue;
			}
		}
	}

	/**
	 * Ensures that the passed in value is not negative while handling a null
	 * input. If value is null, then null will be returned. If value is
	 * negative, 0 is returned.
	 * 
	 * @param value
	 *            the value to check
	 * 
	 * @return the non-negative version of the value.
	 */
	public static Integer nonNegativeValue(Integer value) {
		if (value == null) {
			return value;
		} else {
			if (value < 0) {
				return 0;
			} else {
				return value;
			}
		}
	}
}
