package gov.va.med.fw.util;

import java.util.Collections;
import java.util.Map;

import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.springframework.ui.velocity.VelocityEngineUtils;

/**
 *
 */
public class NotificationUtil {
	private VelocityEngine engine;

	public void init() {

	}

	protected VelocityEngine getEngine() {
		return engine;
	}

	/**
	 * Set the VelocityEngine instance
	 * 
	 * @param engine
	 */
	public void setEngine(VelocityEngine engine) {
		this.engine = engine;
	}

	/**
	 * Merge the template and the data in the Map
	 * 
	 * @param templateName
	 * @param data
	 * @return String
	 */
	public String mergeTemplate(String templateName, Map data) {
		try {
			return VelocityEngineUtils.mergeTemplateIntoString(getEngine(), templateName, data);
		} catch (VelocityException e) {
			throw new RuntimeException("Exception merging template named \"" + templateName
					+ "\" into String.", e);
		}
	}

	/**
	 * Returns a template with no data substitution
	 * 
	 * @param templateName
	 * @return String
	 */
	public String mergeTemplate(String templateName) {
		return mergeTemplate(templateName, Collections.EMPTY_MAP);
	}
}