/********************************************************************
Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

// Package
package gov.va.med.fw.util;

/**
 * A base exception for all application exceptions that are not catastrophic in
 * a business sense. Usually these types of exceptions should not cause an
 * application to stop its current process. A typical usage of this exception is
 * for any scenario that doesn't require an application to roll back its
 * persistent data.
 * 
 * @author Vu Le
 * @version 1.0
 */
public class NonCatastrophicException extends RuntimeException {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -5419639461230634303L;

	/**
	 * Creates new <code>ServiceException</code> without detail message.
	 */
	public NonCatastrophicException() {
		super();
	}

	/**
	 * Creates a new <code>ServiceException</code> with the specific cause
	 */
	public NonCatastrophicException(Throwable cause) {
		super(cause);
	}

	/**
	 * Constructs an <code>ServiceException</code> with the specified detail
	 * message.
	 * 
	 * @param msg
	 *            the detail message.
	 */
	public NonCatastrophicException(String msg) {
		super(msg);
	}

	/**
	 * Constructs an <code>ServiceException</code> with the specified detail
	 * message and a caused exception
	 * 
	 * @param msg
	 *            the detail message.
	 * @param cause
	 *            the caused exception
	 */
	public NonCatastrophicException(String msg, Throwable cause) {
		super(msg, cause);
	}
}
