/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.util;

import java.util.List;

import org.apache.commons.lang.ClassUtils;

import gov.va.med.fw.model.ConfigurableModelProperties;

/**
 * Interface for services that are knowledgable of a model's properties.
 * 
 * Created Mar 14, 2006 2:48:43 PM
 * 
 * @author VHAISABOHMEG
 */
public interface ModelPropertiesManager {
	public static final String CONFIG_SERVICE_KEY = ClassUtils
			.getShortClassName(ModelPropertiesManager.class);

	/**
	 * Returns the set (could be any number) of properties for the interested
	 * application (eg, identity, copying, etc)
	 * 
	 * @param clazz
	 * @param beanType
	 * @return List
	 */
	public ConfigurableModelProperties getConfigurableModelProperties(Class clazz,
			String application);

	public List getModelProperties(Class clazz, String application);

	public List getIdentityProperties(Class clazz);

	public List getCopyProperties(Class clazz);

	public List getMatchDomainValuesProperties(Class clazz);

	public List getMatchDomainConceptProperties(Class clazz);

	public void flushCache();
}
