/********************************************************************
 * Copyriight 2009 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.util;

import gov.va.med.fw.model.HashSummary;

import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;

/**
 * Central utility for hashing needs.
 *
 * Original Author - VHAISWBOHMEG
 * Creation Date - Oct 29, 2009 3:09:41 PM
 */
public class HashUtils {
	public static final char[] HEX_CHARS = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c',
			'd', 'e', 'f' };

	public static final String DEFAULT_ALGORITHM = "SHA-256";
		
	public static HashSummary hash(Object itemToHash, String algorithm) throws Exception {
		return hash(itemToHash, null, algorithm);
	}
	
	public static HashSummary hash(Object itemToHash) throws Exception {
		return hash(itemToHash, null, DEFAULT_ALGORITHM);
	}

	public static HashSummary hash(Object itemToHash, String key, String algorithm) throws Exception{
		if(itemToHash == null && key == null)
			return null;
		
		// TODO: if MessageDigest is thread-safe, could share static instance
		MessageDigest digest = java.security.MessageDigest.getInstance(algorithm);
		
		/*System.out.println("Hash performed using MessageDigest [name / version / info]: [" + digest.getProvider().getName() +
				" / " + digest.getProvider().getVersion() + " / " + digest.getProvider().getInfo() + "]");
		*/
		
		int hash = itemToHash.hashCode();
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		baos.write(hash);
		if ( key != null ) {
			baos.write(key.getBytes());
		}
		digest.update(baos.toByteArray());
		byte[] hashSig = digest.digest();
		char buf[] = new char[hashSig.length * 2];
		for (int i = 0, x = 0; i < hashSig.length; i++) {
			buf[x++] = HEX_CHARS[(hashSig[i] >>> 4) & 0xf];
			buf[x++] = HEX_CHARS[hashSig[i] & 0xf];
		}
		return new HashSummary(new String(buf), digest);
	}
}
