/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.util;

// EDS Classes
import gov.va.med.fw.service.AbstractComponent;

/**
 * Provides an exception handling mechanism for any Exception class. An
 * exception is logged to a logger component then an Exception is returned to a
 * caller for processing
 * 
 * @author Vu Le
 * @version 1.0
 */
public class GenericExceptionHandler extends AbstractComponent implements ExceptionHandler {

	/**
	 * A default constructor
	 */
	public GenericExceptionHandler() {
		super();
	}

	/**
	 * Logs an exception to a logger then returns an exception to a caller for
	 * processing
	 * 
	 * @param exception
	 *            An exception to handle
	 * @param string
	 *            An exception message
	 * @param originator
	 *            An exception's originator
	 */
	public Throwable handleException(Throwable exception, String message, Object originator) {

		if (logger.isErrorEnabled()) {
			logger.error(message, exception);
		}
		return exception;
	}
}