// Package 
package gov.va.med.fw.util;

import java.io.Serializable;

/**
 * A boolean class that implements Comparable. This can be used when you need to
 * sort on a boolean value.
 */
public class ComparableBoolean implements Comparable, Serializable {
	private static final long serialVersionUID = 1002370206000008583L;
	private Boolean bool = null;

	public ComparableBoolean(boolean value) {
		bool = new Boolean(value);
	}

	public ComparableBoolean(String value) {
		bool = new Boolean(value);
	}

	public ComparableBoolean(Boolean value) {
		bool = value;
	}

	public boolean booleanValue() {
		return bool.booleanValue();
	}

	public static ComparableBoolean valueOf(boolean b) {
		return new ComparableBoolean(b);
	}

	public static ComparableBoolean valueOf(String s) {
		return new ComparableBoolean(s);
	}

	public static String toString(boolean b) {
		return Boolean.toString(b);
	}

	public String toString() {
		return bool.toString();
	}

	public int hashCode() {
		return bool.hashCode();
	}

	public boolean equals(Object obj) {
		return bool.equals(obj);
	}

	public static boolean getBoolean(String name) {
		return Boolean.getBoolean(name);
	}

	/**
	 * Compares this ComparableBoolean with the passed in ComparableBoolean or
	 * Boolean object. Comparrisons are done based on the object's toString
	 * values.
	 * 
	 * @param object
	 *            the object to compare
	 * @return the comparrison value
	 */
	public int compareTo(Object object) {
		boolean compareValue = false;
		if (object instanceof ComparableBoolean) {
			compareValue = ((ComparableBoolean) object).booleanValue();
		} else {
			if (object instanceof Boolean) {
				compareValue = ((Boolean) object).booleanValue();
			}
		}
		return bool.toString().compareTo(Boolean.valueOf(compareValue).toString());
	}
}
