package gov.va.med.fw.ui.security;

//Java imports
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;

import gov.va.med.fw.security.EncryptionService;
import gov.va.med.fw.security.EncryptionServiceException;

/**
 * This interface is intended to be used by tags and decryption filter to
 * encrypt and decrypt the information.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public interface UIEncryptionService extends EncryptionService {
	public final static String CRYPTO_PREFIX = "encry";
	public final static String QUERY_STRING_EQUAL = CRYPTO_PREFIX + "=";
	public final static String HIDDEN_FIELD_COLAN = CRYPTO_PREFIX + ":";

	/**
	 * Gets the encryption error page Url.
	 */
	public String getEncryptionErrorUrl();

	/**
	 * Sets the encryption error page Url.
	 */
	public void setEncryptionErrorUrl(String pEncryptionErrorUrl);

	/**
	 * Encrypt the query string part of the url.
	 * 
	 * @param request
	 *            the request object
	 * @param text
	 *            the url to be encrypted
	 * @return encrypted url
	 * 
	 * @throws JspException
	 */
	public String encryptQueryString(ServletRequest request, String text) throws JspException;

	/**
	 * Encrypt the query string part of the hidden field.
	 * 
	 * @param request
	 *            the request object
	 * @param text
	 *            the hidden field value to be encrypted
	 * @return encrypted value
	 * 
	 * @throws JspException
	 */
	public String encryptHiddenField(ServletRequest request, String test) throws JspException;

	/**
	 * Wrapper for the method <code>EncryptionService.encrypt()</code>.
	 * 
	 * @param request
	 *            the request object
	 * @param clearText
	 *            the test to be encrypted
	 * @return the encrypted text
	 * @throws EncryptionServiceException
	 *             thrown when there was an encryption error
	 */
	public String encrypt(ServletRequest request, String clearText)
			throws EncryptionServiceException;

	/**
	 * Decrypts the encrypted text.
	 * 
	 * @param request
	 *            the request object
	 * @param encryptedText
	 *            the encrypted text
	 * @return the decrypted text
	 * @throws EncryptionServiceException
	 *             thrown when there was a decryption error
	 */
	public String decrypt(ServletRequest request, String encryptedText)
			throws EncryptionServiceException;
}