package gov.va.med.fw.ui.model;

import java.util.ArrayList;
import java.util.List;

public class TreeItem {
	private TreeItem parent = null;
	private String label;
	private String value;
	private Boolean enabled = true;
	public List<TreeItem> children = null;

	public TreeItem() {
	}

	public TreeItem(String label, String value, Boolean enabled) {
		super();
		this.label = label;
		this.value = value;
		if (enabled != null)
			this.enabled = enabled;
	}

	/**
	 * @return the children
	 */
	public List<TreeItem> getChildren() {
		return children;
	}

	/**
	 * @param children
	 *            the children to set
	 */
	public void setChildren(List<TreeItem> children) {
		this.children = children;
		// set parent if children is not null;
		if (children != null && children.size() > 0) {
			for (TreeItem child : children) {
				child.parent = this;
			}
		}

	}

	/**
	 * @return the enabled
	 */
	public Boolean getEnabled() {
		return enabled;
	}

	/**
	 * @param enabled
	 *            the enabled to set
	 */
	public void setEnabled(Boolean enabled) {
		this.enabled = enabled;
	}

	/**
	 * @return the label
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * @param label
	 *            the label to set
	 */
	public void setLabel(String label) {
		this.label = label;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}

	public void addChild(TreeItem child) {
		if (children == null)
			children = new ArrayList<TreeItem>();
		child.parent = this;
		children.add(child);
	}

	public void removeChild(TreeItem child) {
		if (children != null) {
			children.remove(child);
		}
	}

	public void removeChildren(List<TreeItem> children) {
		if (this.children != null && children != null) {
			this.children.removeAll(children);
		}
	}

	/**
	 * @return the parent
	 */
	public TreeItem getParent() {
		return parent;
	}

	/**
	 * @param parent
	 *            the parent to set
	 */
	public void setParent(TreeItem parent) {
		this.parent = parent;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((value == null) ? 0 : value.hashCode());
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final TreeItem other = (TreeItem) obj;
		if (value == null) {
			if (other.value != null)
				return false;
		} else if (!value.equals(other.value))
			return false;
		return true;
	}

}
