package gov.va.med.fw.ui.model;

import java.util.Comparator;

public class TermType implements Comparable<TermType>, Comparator<TermType> {

	private String label;
	private String value;
	private Boolean enabled = true;

	public TermType() {
	}

	public TermType(String label, String value) {
		this.label = label;
		this.value = value;
	}

	public TermType(String label, String value, Boolean enabled) {
		this.label = label;
		this.value = value;
		if (enabled != null) {
			this.enabled = enabled;
		}
	}

	public String getLabel() {
		return label;
	}

	public String getValue() {
		return value;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * @return the enabled
	 */
	public Boolean getEnabled() {
		return enabled;
	}

	/**
	 * @param enabled
	 *            the enabled to set
	 */
	public void setEnabled(Boolean enabled) {
		if (enabled != null) {
			this.enabled = enabled;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((value == null) ? 0 : value.hashCode());
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final TermType other = (TermType) obj;
		if (value == null) {
			if (other.value != null)
				return false;
		} else if (!value.equals(other.value))
			return false;
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(TermType obj) {
		if (label != null && obj != null) {
			// disabled items are listed first
			if (enabled.compareTo(((TermType) obj).enabled) == 0) {
				return label.compareTo(((TermType) obj).label);
			}
		}
		return 0;
	}

	public int compare(TermType one, TermType two) {
		if (one != null && two != null) {
			return one.getLabel().compareToIgnoreCase(two.getLabel());
		}
		return 0;
	}
}
