/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.ui.conversion;

// Java classes
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.ui.model.Form;

/**
 * Thye ConversionService interface.
 * 
 * @author Muddaiah Ranga
 * @version 1.0
 */
public interface ConversionService {

	/**
	 * This method converts a BOM to an UI object.
	 * 
	 * @param bom
	 *            the AbstractEntity object
	 * @param form
	 *            the Form object
	 * 
	 * @throws ConversionServiceException
	 *             when aay error occured during converting.
	 */
	public void convert(AbstractEntity bom, Form form) throws ConversionServiceException;

	/**
	 * This method converts an UI object to BOM.
	 * 
	 * @param form
	 *            the Form object
	 * @param bom
	 *            the AbstractEntity object
	 * 
	 * @throws ConversionServiceException
	 *             when aay error occured during converting.
	 */
	public void convert(Form form, AbstractEntity bom) throws ConversionServiceException;
}
