/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.service.trigger;

import gov.va.med.fw.service.jms.JMSMetaData;
import gov.va.med.fw.service.jms.SecureMessageWrapper;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * Initial javadoc for class SecureTriggerEventBuilder. TODO - Add content here
 * 
 * Created Aug 15, 2005 2:36:51 PM
 * 
 * @author VHAISABOHMEG
 */
public class SecureTriggerEventBuilder extends TriggerEventBuilder {
	private boolean shouldExtractTriggerEventPayload = false;

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -2308447587731844524L;

	public Object build(JMSMetaData meta) throws BuilderException {
		// get the TriggerEvent from Message
		TriggerEvent event = (TriggerEvent) super.build(meta);
		// build wrapper
		SecureMessageWrapper wrapper = new SecureMessageWrapper();
		wrapper.setPayload(shouldExtractTriggerEventPayload ? event.getPayload() : event);
		wrapper.setUserCredentials(event.getInitiater());
		return wrapper;
	}

	/**
	 * @param shouldExtractTriggerEventPayload
	 *            The shouldExtractTriggerEventPayload to set.
	 */
	public void setShouldExtractTriggerEventPayload(boolean shouldExtractTriggerEventPayload) {
		this.shouldExtractTriggerEventPayload = shouldExtractTriggerEventPayload;
	}
}
