/**
 * 
 */
package gov.va.med.fw.service.trigger;

import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.jms.JMSServiceException;
import gov.va.med.fw.service.jms.MessageProducerService;

/**
 * @author vhaisakatikm
 * 
 */
public class PublishTriggerableServiceImpl extends AbstractComponent implements
		PublishTriggerableService {

	private MessageProducerService messageProducerService = null;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.fw.service.trigger.PublishTriggerableService#publishTriggerEvent
	 * (gov.va.med.fw.service.trigger.TriggerEvent)
	 */
	public void publishTriggerEvent(TriggerEvent triggerEvent) throws ServiceException {
		publishMessage(triggerEvent);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.fw.service.trigger.TriggerableService#trigger(gov.va.med.fw
	 * .service.trigger.TriggerEvent)
	 */
	public void trigger(TriggerEvent triggerEvent) throws ServiceException {
		publishMessage(triggerEvent);
	}

	/**
	 * Publish message
	 * 
	 * @param triggerEvent
	 */
	protected void publishMessage(TriggerEvent triggerEvent) throws ServiceException {
		if (logger.isDebugEnabled())
			logger.debug("creating async message for TriggerEvent: " + triggerEvent);
		// ensure valid TriggerEvent
		if (triggerEvent.getTriggerIdentity() == null
				|| triggerEvent.getTriggerIdentity().getDestinationType() == null) {
			throw new IllegalStateException(
					"A TriggerEvent must have a non-null getTriggerIdentity().getDestinationType()");
		}

		// set the initiater of this event (if not already set)
		if (triggerEvent.getInitiater() == null) {
			try {
				triggerEvent.setInitiater(SecurityContextHelper.getSecurityContext()
						.getUserPrincipal().getUserCredentials());
			} catch (Exception e) {
				logger
						.warn(
								"At publish time, unable to set TriggerEvent.initiater, most likely because the user is no longer logged in.",
								e);
			}
		}

		if (logger.isInfoEnabled()) {
			logger.info("Publishing TriggerEvent context: " + triggerEvent.getTriggerContext()
					+ " for TriggerEvent identity: " + triggerEvent.getTriggerIdentity());
		}

		try {
			messageProducerService.send(triggerEvent, triggerEvent.getRoutingProperties());
		} catch (JMSServiceException e) {
			logger.error("!! Unable to publish TriggerEvent [" + triggerEvent + "].");
			throw e;
		}
	}

	/**
	 * @return the messageProducerService
	 */
	public MessageProducerService getMessageProducerService() {
		return messageProducerService;
	}

	/**
	 * @param messageProducerService
	 *            the messageProducerService to set
	 */
	public void setMessageProducerService(MessageProducerService messageProducerService) {
		this.messageProducerService = messageProducerService;
	}
}
