/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.service.trigger;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractEntity;

/**
 * Initial javadoc for class AbstractTriggerIdentity. TODO - Add content here
 * 
 * Created Aug 23, 2005 12:02:21 AM
 * 
 * @author VHAISABOHMEG
 */
public abstract class AbstractTriggerIdentity extends AbstractEntity implements TriggerIdentity {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 5720385641520187408L;

	private TargetType targetType;

	private DestinationType destinationType;

	private DispatchType dispatchType;

	private EntityType entityType;

	private boolean usedForConsumerRouting = true;

	/**
	 * Logical name that is given/derived from other data. Marked transient so
	 * it does not impact equality and hashCode check.
	 */
	private transient String name;

	public AbstractTriggerIdentity() {
	}

	public AbstractTriggerIdentity(DestinationType destinationType) {
		this.destinationType = destinationType;
		usedForConsumerRouting = false;
	}

	public AbstractTriggerIdentity(DestinationType destinationType, TargetType targetType,
			DispatchType dispatchType) {
		this.destinationType = destinationType;
		this.targetType = targetType;
		this.dispatchType = dispatchType;
	}

	public AbstractTriggerIdentity(DestinationType destinationType, TargetType targetType,
			DispatchType dispatchType, EntityType entityType) {
		this(destinationType, targetType, dispatchType);
		this.entityType = entityType;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang
	 * .builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		builder.append("destinationType", destinationType);
		builder.append("targetType", targetType);
		builder.append("dispatchType", dispatchType);
		builder.append("entityType", entityType);
	}

	/**
	 * @see gov.va.med.fw.service.trigger.TriggerIdentity#getDestinationType()
	 */
	public DestinationType getDestinationType() {
		return destinationType;
	}

	/**
	 * @see gov.va.med.fw.service.trigger.TriggerIdentity#getTargetType()
	 */
	public TargetType getTargetType() {
		return targetType;
	}

	/**
	 * @see gov.va.med.fw.service.trigger.TriggerIdentity#getDispatchType()
	 */
	public DispatchType getDispatchType() {
		return dispatchType;
	}

	/**
	 * @see gov.va.med.fw.service.trigger.TriggerIdentity#getEntityType()
	 */
	public EntityType getEntityType() {
		return entityType;
	}

	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name != null ? name : buildName();
	}

	protected String buildName() {
		StringBuilder buf = new StringBuilder(destinationType != null ? destinationType.getName()
				: "NO_DESTINATION");
		buf.append(NAME_DELIMITER).append(
				targetType != null ? targetType.getName() : "NO_TARGET_TYPE");
		buf.append(NAME_DELIMITER).append(
				dispatchType != null ? dispatchType.getName() : "NO_DISPATCH_TYPE");
		buf.append(NAME_DELIMITER).append(
				entityType != null ? entityType.getName() : "NO_ENTITY_TYPE");
		return buf.toString();
	}

	/**
	 * @param name
	 *            The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @param dispatchType
	 *            The dispatchType to set.
	 */
	public void setDispatchType(DispatchType dispatchType) {
		this.dispatchType = dispatchType;
	}

	/**
	 * @param entityType
	 *            The entityType to set.
	 */
	public void setEntityType(EntityType entityType) {
		this.entityType = entityType;
	}

	/**
	 * @param targetType
	 *            The targetType to set.
	 */
	public void setTargetType(TargetType targetType) {
		this.targetType = targetType;
	}

	/**
	 * @param destinationType
	 *            The destinationType to set.
	 */
	public void setDestinationType(DestinationType destinationType) {
		this.destinationType = destinationType;
	}

	/**
	 * @return Returns the usedForConsumerRouting.
	 */
	public boolean isUsedForConsumerRouting() {
		return usedForConsumerRouting;
	}

	/**
	 * @param usedForRouting
	 *            The usedForConsumerRouting to set.
	 */
	public void setUsedForConsumerRouting(boolean usedForConsumerRouting) {
		this.usedForConsumerRouting = usedForConsumerRouting;
	}
}
