/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.service.transaction;

import org.apache.commons.lang.Validate;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

import gov.va.med.fw.cache.CacheManager;
import gov.va.med.fw.service.AbstractComponent;

/**
 * Provides global cleanup of CacheManager contents just prior to commit.
 * 
 * Created May 17, 2006 11:42:43 AM
 * 
 * @author VHAISABOHMEG
 */
public class TransactionSynchronizationForCacheManager extends AbstractComponent implements
		TransactionSynchronization {

	public void flush() {
		// TODO Auto-generated method stub
		
	}

	/**
	 * An instance of cacheManager
	 */
	private CacheManager cacheManager = null;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.springframework.transaction.support.TransactionSynchronization#suspend
	 * ()
	 */
	public void suspend() {
		// TODO Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.springframework.transaction.support.TransactionSynchronization#resume
	 * ()
	 */
	public void resume() {
		// TODO Auto-generated method stub

	}

	/**
	 * @see org.springframework.transaction.support.TransactionSynchronization#beforeCommit(boolean)
	 */
	public void beforeCommit(boolean readOnly) {
		// TODO Auto-generated method stub

	}

	/**
	 * @see org.springframework.transaction.support.TransactionSynchronization#afterCommit()
	 */
	public void afterCommit() {
		// TODO Auto-generated method stub
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seeorg.springframework.transaction.support.TransactionSynchronization#
	 * beforeCompletion()
	 */
	public void beforeCompletion() {
		String txName = TransactionSynchronizationManager.getCurrentTransactionName();
		if (txName != null) {
			this.getCacheManager().removeItem(txName);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seeorg.springframework.transaction.support.TransactionSynchronization#
	 * afterCompletion(int)
	 */
	public void afterCompletion(int status) {
		// TODO Auto-generated method stub

	}

	public void afterPropertiesSet() {
		Validate.notNull(this.cacheManager, "A cacheManager is required");
	}

	/**
	 * @return Returns the cacheManager.
	 */
	public CacheManager getCacheManager() {
		return cacheManager;
	}

	/**
	 * @param cacheManager
	 *            The cacheManager to set.
	 */
	public void setCacheManager(CacheManager cacheManager) {
		this.cacheManager = cacheManager;
	}
}