/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.support;

import gov.va.med.fw.service.ServiceException;

// Java classes

// Library classes

// Framework classes

/**
 * A generic start-up service that can be configured to execute a collection of
 * runnable tasks at start-up of a spring's application context. When a spring
 * bean factory initializes this component, a list of runnable tasks is invoked
 * if an activated flag is set to true.
 * 
 * Project: Framework
 * 
 * @author VHAISALEV
 * @version 1.0
 */
public class StartupService extends AbstractRunnableService {

	private boolean activated = false;
	private boolean deamon = true;

	/**
	 * A default constructor
	 */
	public StartupService() {
		super();
	}

	/**
	 * Executes start-up tasks in another thread
	 * 
	 * @see gov.va.med.fw.service.support.AbstractRunnableService#execute()
	 */
	protected void execute() throws ServiceException {
		if (isActivated()) {
			Thread t = new Thread(this);
			t.setDaemon(this.isDeamon());
			t.start();
		}
	}

	/**
	 * Indicates whether a service is activated to execute start-up tasks
	 * 
	 * @return Returns the active to indicate a service is active.
	 */
	public boolean isActivated() {
		return activated;
	}

	/**
	 * Sets a flag to activate this service to run start-up tasks
	 * 
	 * @param flag
	 *            The active flag to set.
	 */
	public void setActivated(boolean flag) {
		this.activated = flag;
	}

	/**
	 * Returns a flag to indicate whether all start-up tasks are executed in a
	 * background
	 * 
	 * @return Returns the deamon.
	 */
	public boolean isDeamon() {
		return deamon;
	}

	/**
	 * Sets a flag to indicate that all startup tasks should be executed in a
	 * background thread
	 * 
	 * @param deamon
	 *            The deamon flag to set.
	 */
	public void setDeamon(boolean deamon) {
		this.deamon = deamon;
	}
}