package gov.va.med.fw.service.support;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.ThreadPool;

/**
 * 
 * @author Rajiv Patnaik Created on Apr 29, 2006
 * @version 1.0
 * 
 *          Copyriight 2006 VHA. All rights reserved
 */
public class SpawnedPooledThreadInvoker extends AbstractComponent {
	private ThreadPool threadPool;
	private SpawnedThreadTask task;

	public SpawnedPooledThreadInvoker(SpawnedThreadTask task, ThreadPool threadPool) {
		this.task = task;
		this.threadPool = threadPool;
	}

	public void execute() {
		if (logger.isDebugEnabled())
			logger.debug("Adding to thread pool for later invocation");

		if (task instanceof Runnable)
			threadPool.invokeLater((Runnable) task);
		else {
			threadPool.invokeLater(new Runnable() {
				public void run() {
					try {
						task.execute();
					} catch (Throwable t) {
						logger.error("Throwable caught in Runnable method", t);
					}
				}
			});
		}
	}

}
