/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.support;

// Library classes
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

import gov.va.med.fw.service.AbstractComponent;

/**
 * A task to shutdown singleton beans in an application context
 * 
 * Project: Framework
 * 
 * @author VHAISALEV
 * @version 1.0
 */
public class ShutdownTask extends AbstractComponent implements Runnable, BeanFactoryAware {

	private BeanFactory factory = null;

	public ShutdownTask() {
		super();
	}

	/**
	 * Initiates an event to destroy all singleton beans registered in a bean
	 * factory.
	 * 
	 * @see java.lang.Runnable#run()
	 */
	public void run() {
		if (factory instanceof ConfigurableListableBeanFactory) {

			if (logger.isDebugEnabled()) {
				logger.debug("Destroying singletons in spring context");
			}
			ConfigurableListableBeanFactory configFactory = (ConfigurableListableBeanFactory) factory;
			configFactory.destroySingletons();
		}
	}

	/**
	 * Sets an instance of a bean factory into this bean
	 * 
	 * @see org.springframework.beans.factory.BeanFactoryAware#setBeanFactory(org.springframework.beans.factory.BeanFactory)
	 */
	public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
		factory = beanFactory;
	}
}