/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.support;

// Framework classes
import gov.va.med.fw.service.ServiceException;

/**
 * Register this service to a JVM runtime to be called when a JVM shutdowns.
 * Default functionality is to shut down spring managed singleton beans.
 * 
 * Project: Framework
 * 
 * @author VHAISALEV
 * @version 1.0
 */
public class ShutdownService extends AbstractRunnableService {

	/**
	 * A default constructor
	 */
	public ShutdownService() {
		super();
	}

	/**
	 * Registers this service to a runtime class to be called when a JVM
	 * shutdowns.
	 * 
	 * @see gov.va.med.fw.service.support.AbstractRunnableService#execute()
	 */
	protected void execute() throws ServiceException {

		if (this.logger.isDebugEnabled()) {
			logger.debug("Registering service " + this.getBeanName() + " to run at shutdown");
		}

		// Register this service
		Runtime rt = Runtime.getRuntime();
		rt.addShutdownHook(new Thread(this));
	}
}
