/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.service.support;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.security.LoginManager;
import gov.va.med.fw.service.AbstractComponent;

/**
 * Abstract class for thread-based tasks.
 * 
 * Created May 3, 2006 8:27:57 PM
 * 
 * @author VHAISABOHMEG
 */
public abstract class AbstractSpawnedThreadTask extends AbstractComponent implements
		SpawnedThreadTask, Runnable {
	private String auditInfo;
	private LoginManager loginManager;

	public void run() {
		try {
			execute();
		} catch (Throwable t) {
			logger.error("Throwable caught in Runnable method", t);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.service.support.SpawnedThreadTask#execute()
	 */
	public Object execute() throws Throwable {
		try {
			loginManager.loginAnonymous(auditInfo);
			executeTask();
		} finally {
			loginManager.logout();
		}
		return null;
	}

	protected abstract void executeTask() throws Throwable;

	/**
	 * @return Returns the loginManager.
	 */
	public LoginManager getLoginManager() {
		return loginManager;
	}

	/**
	 * @param loginManager
	 *            The loginManager to set.
	 */
	public void setLoginManager(LoginManager loginManager) {
		this.loginManager = loginManager;
	}

	public void afterPropertiesSet() {
		Validate.notNull(loginManager, "loginManager is required");
		Validate.notNull(auditInfo, "auditInfo is required");
	}

	/**
	 * @return Returns the auditInfo.
	 */
	public String getAuditInfo() {
		return auditInfo;
	}

	/**
	 * @param auditInfo
	 *            The auditInfo to set.
	 */
	public void setAuditInfo(String auditInfo) {
		this.auditInfo = auditInfo;
	}

}
