/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.ldap;

import java.util.List;

import org.springframework.security.ldap.LdapAuthoritiesPopulator;

import gov.va.med.fw.model.ldap.LdapPerson;
import gov.va.med.fw.model.ldap.SearchCriteria;

/**
 * Service Interface for LdapPerson.
 * 
 * CISS ciss_framework Jun 23, 2008
 * 
 * @author VHAISAANDERC
 */
public interface LdapPersonService extends LdapAuthoritiesPopulator {
	public LdapPerson findByDistinguishedName(String dn);

	public List<LdapPerson> find(SearchCriteria criteria);

	public LdapPerson findBySamAccountName(String sAMAccountName);

	public List<LdapPerson> findAll();

	public void updateGroups(LdapPerson ldapPerson);

	public boolean authenticate(String userDn, String password);
}
