/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.ldap;

import java.util.List;
import java.util.Set;

import gov.va.med.fw.model.ldap.LdapGroup;
import gov.va.med.fw.model.ldap.SearchCriteria;
import gov.va.med.fw.persistent.ldap.LdapGroupDao;

/**
 * Service Implementation for Ldap Group.
 * 
 * CISS ciss_framework Jun 23, 2008
 * 
 * @author VHAISAANDERC
 */
public class LdapGroupServiceImpl implements LdapGroupService {
	private LdapGroupDao groupDao;

	public void setGroupDao(LdapGroupDao groupDao) {
		this.groupDao = groupDao;
	}

	public void create(String name, Set members, List ouList) {
		LdapGroup group = new LdapGroup();
		group.setCnName(name);
		group.setMembers(members);
		group.setOuList(ouList);

		groupDao.create(group);
	}

	public void create(LdapGroup group) {
		groupDao.create(group);
	}

	public void update(LdapGroup group) {
		groupDao.update(group);
	}

	public void delete(LdapGroup group) {
		groupDao.delete(group);
	}

	public LdapGroup findByDistinguishedName(String dn) {
		return groupDao.findByDistinguishedName(dn);
	}

	public List findAll() {
		return groupDao.findAll();
	}

	public LdapGroup findByCN(String groupCn) {
		return groupDao.findByDistinguishedName(groupCn);
	}

	public List find(SearchCriteria criteria) {
		return groupDao.find(criteria);
	}
}
