package gov.va.med.fw.service.jms;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceDescriptor;
import gov.va.med.fw.service.ServiceException;

public class SynchronousMessageProducerServiceImpl extends AbstractComponent implements
		MessageProducerService {

	/**
	 * 
	 */
	private static final long serialVersionUID = 3000126742842857458L;

	public void send(MessagePayload payload) throws MessageProducerException {
		// look up Spring bean based on payload
		ServiceDescriptor serviceDescriptorForMessageConsumer = (ServiceDescriptor) super
				.getApplicationContext().getBean(payload.getTargetServiceDescriptor());
		try {
			serviceDescriptorForMessageConsumer.invokeService(super.getApplicationContext(),
					payload, true);
		} catch (ServiceException e) {
			throw new MessageProducerException("Unable to invoke service", e);
		}
	}

	public void send(Serializable payload) throws MessageProducerException {
		if (!(payload instanceof MessagePayload))
			throw new IllegalArgumentException("Argument must of type MessagePayload");
		send((MessagePayload) payload);
	}

	public void send(Serializable payload, Map<String, Serializable> headerProperties)
			throws MessageProducerException {
		send(payload);
	}

	public void send(Serializable payload, Properties headerProperties)
			throws MessageProducerException {
		send(payload);
	}

	public void sendToAll(MessagePayload payload)
			throws MessageProducerException {
		throw new MessageProducerException("Unimplemented method!");
		
	}

	public void sendToAll(Serializable payload) throws MessageProducerException {
		throw new MessageProducerException("Unimplemented method!");
	}

	public void sendToAll(Serializable payload,
			Map<String, Serializable> headerProperties)
			throws MessageProducerException {
		throw new MessageProducerException("Unimplemented method!");
	}

	public void sendToAll(Serializable payload, Properties headerProperties)
			throws MessageProducerException {
		throw new MessageProducerException("Unimplemented method!");
	}

}
