/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.jms;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

import javax.jms.ConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;

import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.destination.JndiDestinationResolver;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.jndi.JndiTemplate;

import gov.va.med.fw.service.ConfigurationConstants;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.date.TimeZoneUtils;

/**
 * Intended for simple static JMS clients. Most likely used to prime JMS servers
 * and/or test functionality.
 * 
 * <p>
 * Currently does not support fallback providerUrls.
 * </p>
 * 
 * Dec 22, 2008
 * 
 * @author VHAISWBOHMEG
 */
public class JmsSimpleClientUtil {
	private static String KEY_JNDI_INITIAL_CONTEXT_FACTORY = "jndi.initialContextFactory";
	private static String CONFIG_FILE_DEFAULT = "jmsSimpleClient";

	// specific to inbound processing
	private static String KEY_INBOUND_REPEAT_COUNT = "inbound.repeatCount";

	private static String KEY_INBOUND_DELETE_FILE = "inbound.deleteFile";

	private static String KEY_INBOUND_MSG_DIRECTORY = "inbound.messageDirectory";

	private static String KEY_INBOUND_PROVIDER_URL = "inbound.providerURL";

	private static String KEY_JNDI_INBOUND_CONN_FACTORY = "jndi.inbound.ConnFactory";

	private static String KEY_JNDI_INBOUND_DESTINATION = "jndi.inbound.Destination";

	private static int REPEAT_COUNT_DEFAULT = 1;

	private static boolean DELETE_FILE_DEFAULT = true;

	// specific to outbound processing
	private static String KEY_OUTBOUND_MSG_DIRECTORY = "outbound.messageDirectory";

	private static String KEY_OUTBOUND_PROVIDER_URL = "outbound.providerURL";

	private static String KEY_JNDI_OUTBOUND_CONN_FACTORY = "jndi.outbound.ConnFactory";

	private static String KEY_JNDI_OUTBOUND_DESTINATION = "jndi.outbound.Destination";

	private AsynchronousMessageProducerServiceImpl sender = new AsynchronousMessageProducerServiceImpl();

/*	public static void main(String[] args) throws Exception {
		String mode = System.getProperty("jmsSimpleClientMode");
		String jmsSimpleClientConfigFileName = args != null && args.length > 0 ? args[0] : null;
		if (StringUtils.isEmpty(jmsSimpleClientConfigFileName)) {
			jmsSimpleClientConfigFileName = CONFIG_FILE_DEFAULT;
		}
		ResourceBundle bundle = getResourceBundle(jmsSimpleClientConfigFileName);
		if (StringUtils.isEmpty(mode) || "in".equals(mode)) {
			sendMessages(bundle, args);
		} else if ("out".equals(mode)) {
			receiveMessages(bundle, args);
		} else {
			displayHelp();
			System.exit(-1);
		}
	}
*/
	private static void receiveMessages(ResourceBundle bundle, String[] args) {
		System.out.println("receiveMessages() not yet implemented");
	}

	private static void sendMessages(ResourceBundle bundle, String[] args) throws Exception {
		int repeatCount = REPEAT_COUNT_DEFAULT;
		try {
			String repeatCountStr = bundle.getString(KEY_INBOUND_REPEAT_COUNT);
			if (StringUtils.isNotBlank(repeatCountStr)) {
				repeatCount = Integer.parseInt(repeatCountStr);
			}
		} catch (MissingResourceException e) { /* do nothing */
		}

		boolean deleteFile = DELETE_FILE_DEFAULT;
		try {
			String deleteFileStr = bundle.getString(KEY_INBOUND_DELETE_FILE);
			if (StringUtils.isNotBlank(deleteFileStr)) {
				deleteFile = Boolean.valueOf(deleteFileStr).booleanValue();
			}
		} catch (MissingResourceException e) { /* do nothing */
		}

		// Read configuration to create a sender
		String initialContextFactory = bundle.getString(KEY_JNDI_INITIAL_CONTEXT_FACTORY);
		String providerUrl = bundle.getString(KEY_INBOUND_PROVIDER_URL);
		String jndiConnFactory = bundle.getString(KEY_JNDI_INBOUND_CONN_FACTORY);
		String jndiDestination = bundle.getString(KEY_JNDI_INBOUND_DESTINATION);
		/*------------------ Read and send messages -----------------------------------*/
		File directory = new File(bundle.getString(KEY_INBOUND_MSG_DIRECTORY));
		if (!directory.exists())
			directory.mkdir(); // Create Directory
		if ((directory != null) && (directory.isDirectory())) {
			boolean quitDirectory = false;
			JmsSimpleClientUtil simpleClientUtil = new JmsSimpleClientUtil(initialContextFactory,
					providerUrl, jndiConnFactory, jndiDestination);
			Properties props = new Properties();
			props.setProperty(ConfigurationConstants.DEFAULT_MESSAGE_INITIATER,
					JmsSimpleClientUtil.class.getName());
			props.setProperty(ConfigurationConstants.DEFAULT_MESSAGE_ORIGINATING_TIMEZONE,
					TimeZoneUtils.getTimeZone().getID());

			do {
				// Build a map of different message types
				File[] listOfFiles = directory.listFiles();
				for (int i = 0; i < listOfFiles.length; i++) {
					// eliminate version control files
					if (!listOfFiles[i].getName().endsWith(".db")) {
						System.out.println("Processing file : " + listOfFiles[i].getName());

						MessagePayload payload = buildInboundPayload(listOfFiles[i]);
						for (int j = 0; j < repeatCount; j++) {
							try {
								props.setProperty(ConfigurationConstants.DEFAULT_MESSAGE_TYPE,
										payload.getTargetServiceDescriptor());
								simpleClientUtil.sender.send(payload.getPayload(), props);
							} catch (Exception e) {
								e.printStackTrace(System.out);
							}
						}

						if (deleteFile) {
							listOfFiles[i].delete();
						}
					}
				}

				// Check if we need to quit
				System.out.print("Enter (\"quit\" to quit): ");
				BufferedReader msgStream = new BufferedReader(new InputStreamReader(System.in));
				String line = msgStream.readLine();
				if ("quit".equalsIgnoreCase(line)) {
					quitDirectory = true;
				}
			} while (!quitDirectory);
		}
	}

	private static MessagePayload buildInboundPayload(File file) throws IOException {
		FileInputStream stream = new FileInputStream(file);
		BufferedReader reader = new BufferedReader(new InputStreamReader(stream));

		JMSPayload payload = new JMSPayload();

		List<String> rawData = new ArrayList<String>();
		String input = null;
		do {
			input = reader.readLine();
			if (payload.getTargetServiceDescriptor() == null) {
				payload.setTargetServiceDescriptor(input);
			} else if (!StringUtils.isEmpty(input)) {
				rawData.add(input);
			}
		} while (input != null);

		reader.close();
		stream.close();

		if (rawData.size() == 1) {
			// must check if Map of 1
			if (rawData.get(0).indexOf("=") < 0) {
				// must be Map of 1
				payload.setPayload(rawData.get(0));
			}
		}

		if (payload.getPayload() == null) {
			Map<String, String> mapData = new HashMap<String, String>();
			for (String element : rawData) {
				String[] nameValuePair = element.split("=");
				mapData.put(nameValuePair[0], nameValuePair[1]);
			}
			payload.setPayload((Serializable) mapData);
		}
		return payload;
	}

	private ConnectionFactory getConnectionFactory(String initialContextFactory,
			String providerUrl, String jndiConnFactory) throws NamingException {
		JndiTemplate template = getJndiTemplate(initialContextFactory, providerUrl);

		JndiObjectFactoryBean helper = new JndiObjectFactoryBean();
		helper.setJndiTemplate(template);
		helper.setJndiName(jndiConnFactory);
		helper.afterPropertiesSet();

		return (ConnectionFactory) helper.getObject();
	}

	private JndiTemplate getJndiTemplate(String initialContextFactory, String providerUrl) {
		Properties environment = new Properties();
		environment.put(Context.INITIAL_CONTEXT_FACTORY, initialContextFactory);
		environment.put(Context.PROVIDER_URL, providerUrl);

		JndiTemplate template = new JndiTemplate();
		template.setEnvironment(environment);
		return template;
	}

	public JmsSimpleClientUtil(String initialContextFactory, String providerUrl,
			String jndiConnFactory, String jndiDestination) throws NamingException {
		sender.setJmsTemplatePrimary(createJmsTemplate(initialContextFactory, providerUrl,
				jndiConnFactory, jndiDestination));
	}

	protected JmsTemplate createJmsTemplate(String initialContextFactory, String providerUrl,
			String jndiConnFactory, String jndiDestination) throws NamingException {
		JmsTemplate jmsTemplate = new JmsTemplate();
		jmsTemplate.setConnectionFactory(getConnectionFactory(initialContextFactory, providerUrl,
				jndiConnFactory));
		jmsTemplate.setDefaultDestinationName(jndiDestination);
		jmsTemplate.setMessageConverter(new DefaultMessageConverter());
		JndiDestinationResolver resolver = new JndiDestinationResolver();
		resolver.setJndiTemplate(getJndiTemplate(initialContextFactory, providerUrl));
		jmsTemplate.setDestinationResolver(resolver);
		return jmsTemplate;
	}

	private static ResourceBundle getResourceBundle(String fileName) throws Exception {

		if (fileName == null || fileName.length() == 0) {
			throw new IllegalArgumentException("Invalid file name");
		}
		// throw MissingResourceException if failed to locate a resource
		return ResourceBundle.getBundle(fileName);
	}

	private static void displayHelp() {
		System.out.println("\n\n");
		System.out
				.println("Usage: java gov.va.med.fw.service.jms.SimpleClientUtil -DjmsSimpleClientMode=[in|out] <propertyFile>");
		System.out
				.println("Where: <propertyFile>.properties contains JMS configuration information");
	}
}
