/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

// Package
package gov.va.med.fw.service.jms;

// Java classes
import java.util.Properties;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiTemplate;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;

// Framework

/**
 * Encapsulates JMS-related information neccessary to send and receive JMS
 * messages.
 * 
 * @author Vu Le
 * @version 1.0
 */
public class AbstactMessageDescriptor extends AbstractComponent implements InitializingBean {

	private String contextName = null;

	private String providerURL = null;

	private String factoryName = null;

	private JndiTemplate jndi = null;

	/** Creates a new instance of JMSService */
	public AbstactMessageDescriptor() {
		super();
	}

	/**
	 * Checks if a service broker is set correctly
	 * 
	 * @throws Exception
	 *             Thrown if a service broker is not set
	 */
	public void afterPropertiesSet() throws Exception {
		if (factoryName == null || contextName == null || providerURL == null) {
			throw new ServiceException(
					"Missing properties: factoryName, providerURL or contextName");
		}
	}

	public void setContextName(String name) {
		contextName = name;
	}

	public String getContextName() {
		return contextName;
	}

	public void setProviderURL(String name) {
		providerURL = name;
	}

	public String getProviderURL() {
		return providerURL;
	}

	public void setFactoryName(String name) {
		this.factoryName = name;
	}

	public String getFactoryName() {
		return factoryName;
	}

	protected JndiTemplate getInitialContext() {

		if (jndi == null) {
			Properties data = new Properties();
			data.put(Context.INITIAL_CONTEXT_FACTORY, getContextName());
			data.put(Context.PROVIDER_URL, getProviderURL());

			if (logger.isDebugEnabled()) {
				logger.debug(Context.INITIAL_CONTEXT_FACTORY + "=" + getContextName());
				logger.debug(Context.PROVIDER_URL + "=" + getProviderURL());
			}
			jndi = new JndiTemplate(data);
		}
		return jndi;
	}

	/**
	 * 
	 * @param name
	 * @param factoryType
	 * @return
	 * @throws ServiceException
	 */
	protected ConnectionFactory getConnectionFactory(String name, java.lang.Class factoryType)
			throws ServiceException {
		ConnectionFactory factory = null;
		try {
			factory = (ConnectionFactory) PortableRemoteObject.narrow(getInitialContext().lookup(
					name), factoryType);
		} catch (ClassCastException e) {
			throw new ServiceException("Invalid connection factory returned", e);
		} catch (NamingException e) {
			throw new ServiceException("Invalid factory name", e);
		}
		return factory;
	}

	/**
	 * 
	 * @param name
	 * @param objType
	 * @return
	 * @throws ServiceException
	 */

	protected Destination getDestination(String name, java.lang.Class destinationType)
			throws ServiceException {
		Destination destination = null;
		try {
			destination = (Destination) PortableRemoteObject.narrow(getInitialContext()
					.lookup(name), destinationType);
		} catch (ClassCastException e) {
			throw new ServiceException("Invalid destination returned", e);
		} catch (NamingException e) {
			throw new ServiceException("Invalid destination name", e);
		}
		return destination;
	}

}