/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.config;

import java.util.Properties;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

/**
 * @author Madhu Katikala (@user) A property resource configurer that resolves
 *         placeholders in bean property values of context definitions. It
 *         <i>pulls</i> values from a properties file into bean definitions. In
 *         addition to porocessing beans in the current factory, it recursivley
 *         processes the beans in the parent factories as well.
 */
public class RecursivePropertyPlaceholderConfigurer extends PropertyPlaceholderConfigurer {

	/**
	 * Invokes parent's default constructor
	 */
	public RecursivePropertyPlaceholderConfigurer() {
		super();
	}

	/**
	 * Recursively process the beans in the current and all its parent factories
	 */
	protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess,
			Properties props) throws BeansException {
		ConfigurableListableBeanFactory currentFactory = beanFactoryToProcess;
		// process the beans in the factory using the super implementation
		while (currentFactory != null) {
			super.processProperties(currentFactory, props);
			currentFactory = (ConfigurableListableBeanFactory) currentFactory
					.getParentBeanFactory();
		}
	}
}
