/********************************************************************
 * Copyriight 2009 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.cms.impl.weblogic;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;

import com.bea.content.AuthorizationException;
import com.bea.content.Node;
import com.bea.content.ObjectClass;
import com.bea.content.Property;
import com.bea.content.PropertyDefinition;
import com.bea.content.Value;
import com.bea.content.federated.ContentManagerFactory;
import com.bea.content.federated.INodeManager;

import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.cms.Content;
import gov.va.med.fw.service.cms.impl.AbstractContentManagementServiceImpl;

/**
 * CISS ciss_common Sept 29, 2009
 * 
 * @author Muddaiah Ranga
 */
public class ContentManagementServiceImpl extends AbstractContentManagementServiceImpl {
	
	private INodeManager nodeManager;
	
	public String getContent(String nodePath, String property) throws ServiceException {
		Node node = getNode(nodePath);
		try {
			if(node != null && node.isRetired() == false) {
				if("file".equals(property)) {
					InputStream inStream = nodeManager.getStream(getContentContext(),node.getId(), property);
					return convertStreamToString(inStream);
				} else {
					Property prop = getNodeProperty(node,property);
					Value value = prop != null ? prop.getValue() : null;
					return value != null ? value.getStringValue() : null;
				}
			}
			return null;
		} catch(Exception ex) {
			throw new ServiceException("Error while getting node for path " + nodePath + " and property " + property,ex);
		}
	}
	
	public void getContent(Content content) throws ServiceException {
		Node node = getNode(content.getPath());
		try {
			if(node != null && node.isRetired() == false) {
				if("file".equals(content.getProperty())) {
					InputStream inStream = nodeManager.getStream(getContentContext(),node.getId(), content.getProperty());
					content.setPropertyValue(convertStreamToString(inStream));
				} else {
					Property prop = getNodeProperty(node,content.getProperty());
					Value value = prop != null ? prop.getValue() : null;
					content.setPropertyValue(value != null ? value.getStringValue() : null);
				}
				content.setBodyStyle(getStringProperty(node,"bodyStyle"));
				content.setTitle(getStringProperty(node,"title"));
				content.setTitleStyle(getStringProperty(node,"titleStyle"));
				
				content.setStartDate(getDateProperty(node,"startDate"));
				content.setEndDate(getDateProperty(node,"endDate"));
			}
		} catch(Exception ex) {
			throw new ServiceException("Error while getting node for " + content,ex);
		}
	}

	public Content getNodeContent(String nodePath) throws ServiceException {
		// TODO Auto-generated method stub
		return null;
	}
	
	private Node getNode(String path) throws ServiceException {
		try {
			return nodeManager.getNode(getContentContext(),path);
		} catch(Exception ex) {
			throw new ServiceException("Error while getting node for path = " + path,ex);
		}
	}
	
	private String getStringProperty(Node node, String property) 
		throws AuthorizationException {
		if(node != null) {
			Property prop = getNodeProperty(node,property);
			Value value = prop != null ? prop.getValue() : null;
			return value != null ? value.getStringValue() : null;
		}
		return null;
	}
	
	private Date getDateProperty(Node node, String property) 
		throws AuthorizationException {
		if(node != null) {
			Property prop = getNodeProperty(node,property);
			Value value = prop != null ? prop.getValue() : null;
			Calendar endDate = value != null ? value.getCalendarValue() : null;
			return endDate != null ? endDate.getTime() : null;
		}
		return null;
	}
	
	private Property getNodeProperty(Node node, String propertyName)
    	throws AuthorizationException {

		ObjectClass oc = node.getObjectClass();
		if (oc != null) {
			PropertyDefinition[]  pdefs = oc.getPropertyDefinitions();
			if(pdefs != null) {
				for(int i=0; i<pdefs.length; i++) {
					PropertyDefinition pdef = pdefs[i];
					if((pdef != null) && (pdef.getName() != null) && (pdef.getName().equals(propertyName))) {
						return node.getProperty(propertyName);
					}
				}
			}
		}
	    else {
		      Property[] properties = node.getProperties();
		      if(properties != null) {
		    	  for(int i=0; i<properties.length; i++) {
		    		  Property property = properties[i];
		    		  if ((property != null) && (property.getName() != null) && (property.getName().equals(propertyName))) {
				          return property;
		    		  }
		    	  }
		      }
	    }
	    return null;
	  }

	/**
	 * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
	 */
	public void afterPropertiesSet() throws Exception {
		super.afterPropertiesSet();
		nodeManager = ContentManagerFactory.getNodeManager();
	}
}
