/********************************************************************
 * Copyriight 2009 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.cms.impl;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

import com.bea.content.ContentContext;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.cms.ContentManagementService;


/**
 * CISS ciss_common Oct 23, 2009
 * 
 * @author Muddaiah Ranga
 */
public abstract class AbstractContentManagementServiceImpl extends AbstractComponent 
	implements ContentManagementService {
	
	private String contentRepositoryName;
	private String contentRepositoryUserName;
	private String contentRepositoryUserPassword;

	
	public String getContentRepositoryName() {
		return contentRepositoryName;
	}

	public void setContentRepositoryName(String contentRepositoryName) {
		this.contentRepositoryName = contentRepositoryName;
	}

	public String getContentRepositoryUserName() {
		return contentRepositoryUserName;
	}

	public void setContentRepositoryUserName(String contentRepositoryUserName) {
		this.contentRepositoryUserName = contentRepositoryUserName;
	}

	public String getContentRepositoryUserPassword() {
		return contentRepositoryUserPassword;
	}

	public void setContentRepositoryUserPassword(
			String contentRepositoryUserPassword) {
		this.contentRepositoryUserPassword = contentRepositoryUserPassword;
	}
	
	/**
	 * To convert the InputStream to String we use the BufferedReader.readLine() 
	 * method. We iterate until the BufferedReader return null which means  
	 * there's no more data to read. Each line will appended to a StringBuilder  
	 * and returned as String. 
	 */
	protected String convertStreamToString(InputStream is) throws Exception {     
		if(is == null) return null;
		
		BufferedReader reader = new BufferedReader(new InputStreamReader(is));       
		StringBuilder sb = new StringBuilder();        
		try {        
			String line = null;   
			while ((line = reader.readLine()) != null) {               
				sb.append(line);         
			}        
		}catch (Exception ex) {          
			throw ex;     
		} finally {          
			try {             
				is.close();         
			} catch (Exception ex1) {               
				throw ex1;          
			}   
		}        
		return sb.toString(); 
	} 
	
	protected ContentContext getContentContext() {
		
		//ContextKey keyUserName = new ContextKey("username", String.class, true,	false);
		//ContextKey keyPassword = new ContextKey("password", String.class, true,	false);
		//ContentContext context = new ContentContext();
		//context.setParameter(keyUserName, getContentRepositoryUserName());
		//context.setParameter(keyPassword, getContentRepositoryUserPassword());
		
		return new ContentContext();
	}
}
