/********************************************************************
 * Copyriight 2007 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.bpm.impl;

import java.io.Serializable;
import java.util.Map;

import org.apache.commons.lang.Validate;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.springmodules.workflow.jbpm31.JbpmCallback;
import org.springmodules.workflow.jbpm31.JbpmTemplate;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.bpm.WorkflowContext;
import gov.va.med.fw.service.bpm.WorkflowException;
import gov.va.med.fw.service.bpm.WorkflowService;
import gov.va.med.fw.util.StopWatchLogger;
import gov.va.med.fw.util.StringUtils;

/**
 * @author Muddaiah Ranga
 */
public class WorkflowServiceImpl extends AbstractComponent implements WorkflowService {

	public Long initiate(final WorkflowContext executionContext) throws WorkflowException {
		try {
			StopWatchLogger watch = new StopWatchLogger("initiateWorkflow");
			watch.start();

			ProcessInstance processInst = (ProcessInstance) jbpmTemplate
					.execute(new JbpmCallback() {
						public Object doInJbpm(JbpmContext jbpmContext) throws JbpmException {
							ProcessDefinition def = jbpmContext.getGraphSession()
									.findLatestProcessDefinition(
											executionContext.getProcessDefinition());
							ProcessInstance inst = def.createProcessInstance();
							ContextInstance ctxInst = inst.getContextInstance();
							Map<String, Serializable> variables = executionContext.getProcessData();
							if (executionContext.getProcessData() != null) {
								for (String name : variables.keySet()) {
									ctxInst.setVariable(name, variables.get(name));
								}
							}
							inst.signal();
							jbpmContext.save(inst);
							return inst;
						}
					});

			watch.stopAndLog();

			return (processInst != null) ? new Long(processInst.getId()) : null;
		} catch (JbpmException ex) {
			throw new WorkflowException("Error while initiating workflow", ex);
		}
	}

	public ProcessInstance getProcessInstance(final WorkflowContext executionContext)
			throws WorkflowException {
		try {
			return (ProcessInstance) getJbpmTemplate().execute(new JbpmCallback() {
				public Object doInJbpm(JbpmContext jbpmContext) throws JbpmException {
					return jbpmContext.getProcessInstance(executionContext.getProcessId());
				}
			});
		} catch (JbpmException ex) {
			throw new WorkflowException("Error while getting process instance", ex);
		}
	}

	public void completeTask(final WorkflowContext executionContext) throws WorkflowException {
		try {
			getJbpmTemplate().execute(new JbpmCallback() {
				public Object doInJbpm(JbpmContext jbpmContext) throws JbpmException {
					ProcessInstance inst = (ProcessInstance) jbpmContext
							.getProcessInstance(executionContext.getProcessId());
					if (inst != null && inst.hasEnded() == false) {
						if (StringUtils.isNotEmpty(executionContext.getTransition())) {
							inst.signal(executionContext.getTransition());
						} else {
							inst.signal();
						}
						jbpmContext.save(inst);
					}
					return null;
				}
			});
		} catch (JbpmException ex) {
			throw new WorkflowException("Error while completing task", ex);
		}
	}

	public void cancel(final WorkflowContext executionContext) throws WorkflowException {
		try {
			getJbpmTemplate().execute(new JbpmCallback() {
				public Object doInJbpm(JbpmContext jbpmContext) throws JbpmException {
					ProcessInstance inst = (ProcessInstance) jbpmContext
							.getProcessInstance(executionContext.getProcessId());
					if (inst != null && inst.hasEnded() == false) {
						inst.end();
						jbpmContext.save(inst);
					}
					return null;
				}
			});
		} catch (JbpmException ex) {
			throw new WorkflowException("Error while cancelling process", ex);
		}
	}

	protected JbpmTemplate jbpmTemplate;

	public JbpmTemplate getJbpmTemplate() {
		return jbpmTemplate;
	}

	public void setJbpmTemplate(JbpmTemplate jbpmTemplate) {
		this.jbpmTemplate = jbpmTemplate;
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		super.afterPropertiesSet();
		Validate.notNull(jbpmTemplate, "Missing required jbpmTemplate");
	}
}
