package gov.va.med.fw.service.bpm.impl;

import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.job.executor.JobExecutor;

import gov.va.med.fw.util.StringUtils;

public class JbpmTemplate extends org.springmodules.workflow.jbpm31.JbpmTemplate {

	public final static String AUTO_START_JBPM = "org.jboss.jbpm.autoStart";

	public JbpmTemplate() {
	}

	public JbpmTemplate(JbpmConfiguration jbpmConfiguration) {
		setJbpmConfiguration(jbpmConfiguration);
	}

	public JbpmTemplate(JbpmConfiguration jbpmConfiguration, ProcessDefinition processDefinition) {
		setJbpmConfiguration(jbpmConfiguration);
		setProcessDefinition(processDefinition);
	}

	/**
	 * Start the JOB executor after the initialization.
	 */
	public void afterPropertiesSet() throws Exception {

		super.afterPropertiesSet();

		// Start the JobExcecutor only when the flag is set
		if (isAutoStartJbpm()) {
			JobExecutor jobExecutor = jbpmConfiguration.getJobExecutor();
			if (jobExecutor != null) {
				jobExecutor.setJbpmConfiguration(jbpmConfiguration);
				jobExecutor.start();
			}
		}
	}

	public boolean isAutoStartJbpm() {
		String prop = System.getProperties().getProperty(AUTO_START_JBPM);
		return (prop == null || StringUtils.equals(prop, "true")) ? true : false;
	}

}
