/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service;

import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.StringUtils;

/**
 * The user does not have the capability to perform an operation.
 * <p/>
 * Created Apr 10, 2006 12:33:59 PM
 * 
 * @author VHAISABOHMEG
 */
public class MissingCapabilityException extends ServiceException {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -227431030035754407L;
	private Lookup missingCapability;

	public MissingCapabilityException(String message) {
		super(message);
	}

	public MissingCapabilityException(Lookup missingCapability) {
		this.missingCapability = missingCapability;
	}

	public MissingCapabilityException(String message, Lookup missingCapability) {
		super(message);
		this.missingCapability = missingCapability;
	}

	public MissingCapabilityException(String message, Lookup missingCapability, Throwable t) {
		super(message, t);
		this.missingCapability = missingCapability;
	}

	/**
	 * @return Returns the missingCapability.
	 */
	public Lookup getMissingCapability() {
		return missingCapability;
	}

	/**
	 * @param missingCapability
	 *            The missingCapability to set.
	 */
	public void setMissingCapability(Lookup missingCapability) {
		this.missingCapability = missingCapability;
	}

	public String getMessage() {
		String message = super.getMessage();
		if (StringUtils.isEmpty(message)) {
			if (missingCapability != null) {
				return "Required capability " + missingCapability.getCode() + " ("
						+ missingCapability.getDescription() + ") is needed "
						+ "to perform this operation.";
			} else {
				return "A required capability is needed to perform this operation.";
			}
		}
		return message;
	}
}
