/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security.jaas;

import java.util.List;

import javax.security.auth.login.LoginException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * JAAS Login module implementation. This login module delegate the actual
 * authentication call to the security service. This class gets the service
 * target name from the module option named "seviceTarget". If no such option is
 * specified, it uses the default name of "securityServiceTarget".
 * 
 * @author vhaisamansog
 * @datetime Mar 22, 2005
 */
public class LoginModuleImpl extends AbstractUserPasswordLoginModule {
	protected transient Log logger = LogFactory.getLog(getClass());

	/*
	 * Perform the user authentication by delegating a request to
	 * SecurityService.
	 * 
	 * @see
	 * gov.vha.edb.service.impl.AbstractLoginModule#authenticate(java.lang.String
	 * , char[])
	 */
	protected List authenticate(String username, char[] password) throws LoginException {

		return null;
	}

	/*
	 * Method to debug the log messages if module debug option is true.
	 * 
	 * @see
	 * gov.va.med.fw.security.jaas.AbstractUserPasswordLoginModule#logDebug(
	 * java.lang.String)
	 */
	protected void logDebug(String msg) {
		logger.debug(msg);
	}
}