/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;

import org.springframework.security.GrantedAuthority;

/**
 * UserPrincipal, extends from Principal, UserDetails and provides user profile
 * and UserPrincipal also contains a set of GrantedAuthorities or roles
 * 
 * @author VHAISAKATIKM
 * @version 1.0
 */
public interface UserPrincipal extends Principal, Serializable {

	/**
	 * First name of the user
	 * 
	 * @return String - given name of a user
	 */
	public String getGivenName();

	/**
	 * Middle name of the user
	 * 
	 * @return String - middle name of a user
	 */
	public String getMiddleName();

	/**
	 * Family name of the user
	 * 
	 * @return String - family name of a user
	 */
	public String getFamilyName();

	/**
	 * @return String - password of the user
	 */
	public String getPassword();

	/**
	 * Check whether is user the anonymous user or not.
	 * 
	 * @return true if anonymous, false otherwise.
	 */
	public boolean isAnonymous();

	/**
	 * Get generic Authority object that implements GrantedAuthority Interface
	 * 
	 * @return
	 */
	public GrantedAuthority[] getAuthorities();

	/**
	 * Get the user credentials information for this Principal
	 * 
	 * @return UserCredentials
	 */
	public UserCredentials getUserCredentials();

	/**
	 * Verify whether user has the specified authority granted
	 * 
	 * @param permission
	 * @return
	 */
	public boolean isPermissionGranted(String permission);

	/**
	 * Verify whether user has one of the specified authority granted
	 * 
	 * @param permissions
	 * @return
	 */
	public boolean isRoleGranted(Collection permissions);

	/**
	 * Get users full name for display purposes
	 * 
	 * @return
	 */
	public String getFullName();

	public boolean isInactive();

	public Date getInactiveDate();

	public String getInactiveMessage();

	public boolean isAccountLocked();

	public TimeZone getCurrentTimeZone();

	public void setCurrentTimeZone(TimeZone timeZone);

	public String getDepartment();

	public String getTitle();

	public String getDescription();

	public String getOffice();

	public String getTelephoneNumber();

	public String getEmail();

	public Set<String> getLdapRoles();
}