/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security;

import java.util.Set;

import gov.va.med.fw.service.ServiceException;

/**
 * Security Service defines user authentication related operations.
 * 
 * @author Ghazenfer Mansoor
 */
public interface SecurityService {
	/**
	 * Get User by Name
	 * 
	 * @param userName
	 * @return
	 * @throws ServiceException
	 */
	public UserPrincipal getUser(String userName) throws ServiceException;

	/**
	 * Get role by name
	 * 
	 * @param roleName
	 * @return
	 * @throws ServiceException
	 */
	public Role getRole(String roleName) throws ServiceException;

	/**
	 * Get Application by name
	 * 
	 * @param applicationName
	 * @return
	 * @throws ServiceException
	 */
	public Application getApplication(String applicationName) throws ServiceException;

	/**
	 * Get role associated permission names
	 * 
	 * @param roles
	 * @return
	 * @throws ServiceException
	 */
	public Set<String> getRolePermissionNames(Set<Role> roles) throws ServiceException;

	/**
	 * Update user account for successfull login
	 * 
	 * @param userName
	 * @throws ServiceException
	 */
	public void updateSuccessFulLogin(String userName) throws ServiceException;

	/**
	 * 
	 * @param userPrincipal
	 * @throws ServiceException
	 */
	public void updateSuccessFulLogin(UserPrincipal userPrincipal, boolean updateRoles) throws ServiceException;

	/**
	 * Update user account for failed login
	 * 
	 * @param userName
	 * @throws ServiceException
	 */
	public boolean updateFailedLogin(String userName) throws ServiceException;

	public UserPrincipal getAuditUser(String userName) throws ServiceException;
}