/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security;

import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * 
 * CISS ciss_framework Jun 26, 2008
 * 
 * @author vhaisakatikm
 */
public class RolePermission extends AbstractKeyedEntity {

	private static final long serialVersionUID = -4521010384242468103L;

	private Role role;
	private Permission permission;
	private boolean inactive = false; // not used in ciss but have db constraint

	/**
	 * @return the permission
	 */
	public Permission getPermission() {
		return permission;
	}

	/**
	 * @param permission
	 *            the permission to set
	 */
	public void setPermission(Permission permission) {
		this.permission = permission;
	}

	/**
	 * @return the role
	 */
	public Role getRole() {
		return role;
	}

	/**
	 * @param role
	 *            the role to set
	 */
	public void setRole(Role role) {
		this.role = role;
	}

	/**
	 * @return the inactive
	 */
	public boolean isInactive() {
		return inactive;
	}

	/**
	 * @param inactive
	 *            the inactive to set
	 */
	public void setInactive(boolean inactive) {
		this.inactive = inactive;
	}
}
