/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.springframework.security.GrantedAuthority;

import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * 
 * CISS ciss_framework Jun 26, 2008
 * 
 * @author vhaisakatikm
 */
public class Role extends AbstractKeyedEntity implements GrantedAuthority {

	private static final long serialVersionUID = -4464647987438818049L;

	public static final String DEFAULT_CISS_APP_ROLE = "CISS_USER";
	public static final String DEFAULT_OHRS_APP_ROLE = "OHRS_USER";

	private Application application;
	private String name;
	private String description;
	private boolean inactive = false;
	private Date inactiveDate = null;
	private Set<RolePermission> internalPermissions = null;

	/**
	 * @return the application
	 */
	public Application getApplication() {
		return application;
	}

	/**
	 * @param application
	 *            the application to set
	 */
	public void setApplication(Application application) {
		this.application = application;
	}

	/**
	 * @return the inactive
	 */
	public boolean isInactive() {
		return inactive;
	}

	/**
	 * @param inactive
	 *            the inactive to set
	 */
	public void setInactive(boolean inactive) {
		this.inactive = inactive;
	}

	/**
	 * @return the inactiveDate
	 */
	public Date getInactiveDate() {
		return inactiveDate;
	}

	/**
	 * @param inactiveDate
	 *            the inactiveDate to set
	 */
	public void setInactiveDate(Date inactiveDate) {
		this.inactiveDate = inactiveDate;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @param description
	 *            the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the internalPermissions
	 */
	public Set<Permission> getPermissions() {
		Set<Permission> permissions = new HashSet<Permission>();
		for (Iterator i = getInternalPermissions().iterator(); i.hasNext();) {
			permissions.add(((RolePermission) i.next()).getPermission());
		}
		return permissions;
	}

	/**
	 * @param internalPermissions
	 *            the internalPermissions to set
	 */
	public void setPermissions(Set<Permission> permissions) {

		Set<Permission> newSet = new HashSet<Permission>();
		newSet.addAll(permissions);

		// old permission map
		Map<Permission, RolePermission> oldMap = new HashMap<Permission, RolePermission>();
		for (Iterator i = getInternalPermissions().iterator(); i.hasNext();) {
			RolePermission rolePermission = (RolePermission) i.next();
			oldMap.put(rolePermission.getPermission(), rolePermission);
		}

		// retain the existing ones and remove the deleted ones
		for (Iterator i = oldMap.keySet().iterator(); i.hasNext();) {
			Permission permission = (Permission) i.next();
			if (newSet.contains(permission)) {
				// an existing permission
				newSet.remove(permission);
			} else {
				// deleted permission
				RolePermission delRolePermission = (RolePermission) oldMap.get(permission);
				boolean removed = getInternalPermissions().remove(delRolePermission);
				delRolePermission.setRole(null);
			}
		}

		// add the new stations
		for (Iterator i = newSet.iterator(); i.hasNext();) {
			Permission permission = (Permission) i.next();
			RolePermission rolePermission = new RolePermission();
			rolePermission.setPermission(permission);
			rolePermission.setRole(this);
			getInternalPermissions().add(rolePermission);
		}
	}

	/**
	 * @return the internalPermissions
	 */
	private Set<RolePermission> getInternalPermissions() {
		if (this.internalPermissions == null)
			this.internalPermissions = new HashSet<RolePermission>();
		return internalPermissions;
	}

	/**
	 * @param internalPermissions
	 *            the internalPermissions to set
	 */
	private void setInternalPermissions(Set<RolePermission> internalPermissions) {
		this.internalPermissions = internalPermissions;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	public String getAuthority() {
		return getName();
	}

	/**
	 * Implement the compare function on the role name
	 */
	public int compareTo(Object obj) {
		if (name == null) {
			return -1;
		} else if (obj != null && Role.class.isAssignableFrom(obj.getClass())) {
			Role target = (Role) obj;
			if (target.name == null) {
				return 1;
			} else {
				return name.compareTo(target.name);
			}
		}
		return 0;
	}
}
