/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security;

import java.math.BigInteger;

import javax.crypto.spec.SecretKeySpec;

import gov.va.med.fw.service.ServiceException;

/**
 * Encryption service to encrypt passwords using des3 or des specified in the
 * configuration Encrypted password is prefixed with alogorithm prefix for
 * identification of encrypted passwords
 * 
 * Uses the generic implementation in the base class for encryption
 * 
 * @author VHAISAKATIKM
 * 
 */
public class PasswordEncryptionServiceImpl extends EncryptionServiceImpl implements
		PasswordEncryptionService {

	public static final String DES_PREFIX = "{DES}";
	public static final String DES3_PREFIX = "{DES3}";

	public static final String ENCRYPTION_ALOGORITHM_DES3 = "DESede";
	public static final String ENCRYPTION_ALOGORITHM_DES = "{DES3}";

	private String encryptionKey = null;
	private SecretKeySpec skeySpec = null;
	private String encryptionPrefix = DES_PREFIX;

	public static final String blank_string = "                ";

	/**
	 * Craete encryption service object
	 */
	public PasswordEncryptionServiceImpl() {
		super();
	}

	public String getEncryptionKey() {
		return encryptionKey;
	}

	public void setEncryptionKey(String encryptionKey) {
		this.encryptionKey = encryptionKey;
	}

	private SecretKeySpec getSkeySpec() {
		return skeySpec;
	}

	private void setSkeySpec(SecretKeySpec skeySpec) {
		this.skeySpec = skeySpec;
	}

	/**
	 * Encrypt password and return encrypted password If the password already
	 * encrypted return as is
	 */
	public String encryptPassword(String cleartext) throws ServiceException {
		// if the the text already encrypted returned as is
		if (cleartext.startsWith(DES_PREFIX) || cleartext.startsWith(DES3_PREFIX)) {
			return cleartext;
		}
		String newText = cleartext;
		String encrypted = encrypt(getSkeySpec(), null, newText, null);
		return encryptionPrefix + encrypted;
	}

	/**
	 * create the Secret Key from the specified encryption key and encryption
	 * method
	 */
	public void afterPropertiesSet() throws Exception {
		super.afterPropertiesSet();

		// create key specification - encryption key is stored as hexa decimal
		// number
		byte[] bytearray = new BigInteger(getEncryptionKey(), 16).toByteArray();
		setSkeySpec(new SecretKeySpec(bytearray, getAlgorithm()));
		if (getAlgorithm().startsWith(ENCRYPTION_ALOGORITHM_DES3)) {
			encryptionPrefix = DES3_PREFIX;
		} else {
			// default alogorithm
			encryptionPrefix = DES_PREFIX;
		}
	}
}
