/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.scheduling;

import java.util.Date;
import java.util.TimeZone;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.util.date.DateWithTimeZone;

/**
 * Contains status information about a Trigger that could be used for
 * instrumentation needs.
 * 
 * Created Jun 26, 2006 2:21:42 PM
 * 
 * @author VHAISABOHMEG
 */
public class TriggerStatus extends AbstractEntity {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 9003524138022133858L;
	public static String NORMAL_STATUS = "WAITING";
	public static String PAUSED_STATUS = "PAUSED";

	private Date nextFireTime;
	private String status;
	private TimeZone timeZone;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang
	 * .builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		builder.append("nextFireTime", nextFireTime);
		builder.append("timeZone", timeZone);
		builder.append("status", status);
	}

	/**
	 * @return Returns the nextFireTime.
	 */
	public Date getNextFireTime() {
		return nextFireTime;
	}

	/**
	 * @param nextFireTime
	 *            The nextFireTime to set.
	 */
	public void setNextFireTime(Date nextFireTime) {
		this.nextFireTime = nextFireTime;
	}

	/**
	 * @return Returns the status.
	 */
	public String getStatus() {
		return status;
	}

	/**
	 * @param status
	 *            The status to set.
	 */
	public void setStatus(String status) {
		this.status = status;
	}

	public TimeZone getTimeZone() {
		return timeZone;
	}

	public void setTimeZone(TimeZone timeZone) {
		this.timeZone = timeZone;
	}

	public DateWithTimeZone getNextFireTimeWithTimeZone() {
		return nextFireTime == null ? null : new DateWithTimeZone(nextFireTime, timeZone);
	}

	public boolean isActive() {
		return NORMAL_STATUS.equals(status);
	}
}
