/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.scheduling;

import java.text.ParseException;

import org.apache.commons.lang.Validate;
import org.springframework.scheduling.quartz.CronTriggerBean;

/**
 * A CronTrigger that can be dynamically changed at runtime via a
 * SystemParameter. Since it can change, application init should not overwrite
 * its state in a persistent JobStore (if any).
 * 
 * Created Jun 7, 2006 4:46:06 PM
 * 
 * @author VHAISABOHMEG
 */
public class DynamicCronTriggerBean extends CronTriggerBean implements ImmutableInitTrigger {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8833859523012999631L;
	private String systemParameterName;

	/**
	 * @return Returns the systemParameterName.
	 */
	public String getSystemParameterName() {
		return systemParameterName;
	}

	/**
	 * @param systemParameterName
	 *            The systemParameterName to set.
	 */
	public void setSystemParameterName(String systemParameterName) {
		this.systemParameterName = systemParameterName;
	}

	public void afterPropertiesSet() throws ParseException {
		try {
			super.afterPropertiesSet();
		}catch (Exception e) {
			Validate.notNull(systemParameterName, "systemParameterName is null");
		}
	}
}
