package gov.va.med.fw.rule.impl.drools;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.audit.WorkingMemoryConsoleLogger;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.event.WorkingMemoryEventListener;
import org.drools.rule.Package;
import org.drools.rule.builder.dialect.java.JavaDialectConfiguration;
import org.springframework.core.io.ClassPathResource;

import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleEngine;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.rule.RuleParameter;
import gov.va.med.fw.rule.RuleParameters;
import gov.va.med.fw.rule.SimpleRuleData;
import gov.va.med.fw.service.AbstractComponent;

/**
 * 
 * @author vhaisakatikm
 * 
 */
public class DroolsRuleEngine extends AbstractComponent implements RuleEngine {
	private RuleBase ruleBase = null;
	private List<DroolsRulePackage> rulePackages = null;
	private PackageBuilderConfiguration pkgBuilderCfg = null;

	public DroolsRuleEngine() {
		super();
		// Create new Rule Base
		ruleBase = RuleBaseFactory.newRuleBase();
		// Fix for JDT compiler problem
		pkgBuilderCfg = new PackageBuilderConfiguration();
		JavaDialectConfiguration javaConf = (JavaDialectConfiguration) pkgBuilderCfg
				.getDialectConfiguration("java");
		javaConf.setCompiler(JavaDialectConfiguration.JANINO);
	}

	public Object execute(RuleParameters params, RuleDataAware data) throws RuleException {
		// TODO Auto-generated method stub
		return null;
	}

	public Object execute(RuleParameters params, Map data) throws RuleException {
		// TODO Auto-generated method stub
		return null;
	}

	public Object execute(RuleParameter param, RuleDataAware data) throws RuleException {
		// TODO Auto-generated method stub
		return null;
	}

	public void executeRuleFlow(String ruleFlowNameId, SimpleRuleData ruleDataObject)
			throws RuleException {
		List<SimpleRuleData> listOfOne = new ArrayList<SimpleRuleData>();
		listOfOne.add(ruleDataObject);
		executeRuleFlow(ruleFlowNameId, listOfOne);
	}

	public void executeRuleFlow(String ruleFlowNameId, List ruleDataObjects) throws RuleException {
		try {
			// Create new stateful session (new working memory in version 3.*)
			WorkingMemory wm = ruleBase.newStatefulSession();
			// if (logger.isDebugEnabled()) {
			wm.addEventListener((WorkingMemoryEventListener) (new WorkingMemoryConsoleLogger(wm)));
			// }

			// load the rule data
			if (ruleDataObjects != null && ruleDataObjects.size() > 0) {
				for (Object obj : ruleDataObjects) {
					if (obj != null) {
						// FactHandle stiltonHandle =
						wm.insert(obj);
					}
				}
			}
			// This is not the ruleflow name and is the id of the rule flow
			wm.startProcess(ruleFlowNameId);// ruleflow id to be executed

			// Fire All Rules
			wm.fireAllRules();
			System.out.println("All Rules Fired");
			// Close the session
			// Gets garbage collected automatically
			// wm.
		} catch (Exception e) {
			throw new RuleException("Rule Flow  execution failed: " + e.getMessage(), e);
		}
	}

	public RuleBase getRuleBase() {
		return ruleBase;
	}

	public List<DroolsRulePackage> getRulePackages() {
		return rulePackages;
	}

	public void setRulePackages(List<DroolsRulePackage> rulePackages) {
		this.rulePackages = rulePackages;
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		super.afterPropertiesSet();
		// load rule packages
		loadRulePackages();
	}

	public void loadRulePackages() throws RuleException {
		if (rulePackages != null && rulePackages.size() > 0) {
			for (DroolsRulePackage rulePackage : rulePackages) {
				loadRulePackage(rulePackage);
			}
		}
	}

	/**
	 * Read rule resources and create the RuleBase
	 * 
	 * @throws RuleException
	 */
	private void loadRulePackage(DroolsRulePackage rulePackage) throws RuleException {
		if (rulePackage == null)
			return;

		PackageBuilder builder = new PackageBuilder(pkgBuilderCfg);

		// Load rules
		try {
			List<String> ruleFileNames = rulePackage.getRuleFileNames();

			if (ruleFileNames != null && ruleFileNames.size() > 0) {
				// load rules with dsl
				String dslFileName = rulePackage.getRuleDSLFileName();
				if (dslFileName != null && dslFileName.length() > 0) {
					for (String ruleResoucreFileName : ruleFileNames) {
						Reader dslSource = getSourceReader(dslFileName);
						Reader ruleSource = getSourceReader(ruleResoucreFileName);
						builder.addPackageFromDrl(ruleSource, dslSource);
					}
				}
				// load rules withour dsl
				else {
					for (String ruleResoucreFileName : ruleFileNames) {
						Reader ruleSource = getSourceReader(ruleResoucreFileName);
						builder.addPackageFromDrl(ruleSource);
					}
				}
			}
			// Load rule flows
			List<String> ruleFlowFileNames = rulePackage.getRuleFlowFileNames();
			if (ruleFlowFileNames != null && ruleFlowFileNames.size() > 0) {
				for (String ruleResoucreFileName : ruleFlowFileNames) {
					Reader ruleFlowsource = getSourceReader(ruleResoucreFileName);
					builder.addRuleFlow(ruleFlowsource);
				}
			}
		} catch (IOException ioe) {
			// could not load rule resources
			throw new RuleException("Failed to load rule resources: " + ioe.getMessage(), ioe);
		} catch (DroolsParserException dpe) {
			// could not load rule resources
			throw new RuleException("Failed to parse rule resources : " + dpe.getMessage(), dpe);
		}

		// Get the rule package from the builder
		Package pkg = builder.getPackage();

		// Add rules package to the rulebase
		try {
			ruleBase.addPackage(pkg);
		} catch (Exception e) {
			// could not add rules to the rulebase
			throw new RuleException("Failed to create the rulebase: " + e.getMessage(), e);
		}
	}

	/**
	 * Associated an input stream reader to the file
	 * 
	 * @param fileName
	 * @return
	 * @throws RuleException
	 */
	private Reader getSourceReader(String fileName) throws RuleException {
		try {
			Reader inputStreamReader = new InputStreamReader(new ClassPathResource(fileName)
					.getInputStream());
			// DroolsRuleEngine.class.getResourceAsStream(fileName));
			return inputStreamReader;
		} catch (Exception e) {
			throw new RuleException("Failed to read the rule resource file : " + fileName);
		}
	}
}
